<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckShipmentRegionalizationRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на проверку правил регионализации для определенной категории груза и маршрута следования. | Категория груза, для
 * которой запрашиваются правила перемещения по маршруту. | Маршрут следования груза. В отличие от маршрута следования, который
 * указывается в транспортном сертификате и в запросе на оформление исходящей партии, `shipmentRoute` здесь должен включать точку отправления и
 * точку назначения. Для каждой точки маршрута обязательно должен быть заполнен адрес: элементы `shipmentRoute/routePoint/location/address` и
 * `shipmentRoute/routePoint/enterprise/address`. Только в этом случае проверка правил перемещения (регионализация) даст корректный результат.
 * @subpackage Structs
 */
class CheckShipmentRegionalizationRequest extends MercuryApplicationRequest
{
    /**
     * The cargoType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - ref: dt:cargoType
     * @var \StructType\SubProduct[]
     */
    public $cargoType;
    /**
     * The shipmentRoute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: vd:shipmentRoute
     * @var \StructType\ShipmentRoute
     */
    public $shipmentRoute;
    /**
     * Constructor method for CheckShipmentRegionalizationRequest
     * @uses CheckShipmentRegionalizationRequest::setCargoType()
     * @uses CheckShipmentRegionalizationRequest::setShipmentRoute()
     * @param \StructType\SubProduct[] $cargoType
     * @param \StructType\ShipmentRoute $shipmentRoute
     */
    public function __construct(array $cargoType = array(), \StructType\ShipmentRoute $shipmentRoute = null)
    {
        $this
            ->setCargoType($cargoType)
            ->setShipmentRoute($shipmentRoute);
    }
    /**
     * Get cargoType value
     * @return \StructType\SubProduct[]
     */
    public function getCargoType()
    {
        return $this->cargoType;
    }
    /**
     * Set cargoType value
     * @throws \InvalidArgumentException
     * @param \StructType\SubProduct[] $cargoType
     * @return \StructType\CheckShipmentRegionalizationRequest
     */
    public function setCargoType(array $cargoType = array())
    {
        foreach ($cargoType as $checkShipmentRegionalizationRequestCargoTypeItem) {
            // validation for constraint: itemType
            if (!$checkShipmentRegionalizationRequestCargoTypeItem instanceof \StructType\SubProduct) {
                throw new \InvalidArgumentException(sprintf('The cargoType property can only contain items of \StructType\SubProduct, "%s" given', is_object($checkShipmentRegionalizationRequestCargoTypeItem) ? get_class($checkShipmentRegionalizationRequestCargoTypeItem) : gettype($checkShipmentRegionalizationRequestCargoTypeItem)), __LINE__);
            }
        }
        $this->cargoType = $cargoType;
        return $this;
    }
    /**
     * Add item to cargoType value
     * @throws \InvalidArgumentException
     * @param \StructType\SubProduct $item
     * @return \StructType\CheckShipmentRegionalizationRequest
     */
    public function addToCargoType(\StructType\SubProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubProduct) {
            throw new \InvalidArgumentException(sprintf('The cargoType property can only contain items of \StructType\SubProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->cargoType[] = $item;
        return $this;
    }
    /**
     * Get shipmentRoute value
     * @return \StructType\ShipmentRoute
     */
    public function getShipmentRoute()
    {
        return $this->shipmentRoute;
    }
    /**
     * Set shipmentRoute value
     * @param \StructType\ShipmentRoute $shipmentRoute
     * @return \StructType\CheckShipmentRegionalizationRequest
     */
    public function setShipmentRoute(\StructType\ShipmentRoute $shipmentRoute = null)
    {
        $this->shipmentRoute = $shipmentRoute;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckShipmentRegionalizationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
