<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessErrorList StructType
 * @subpackage Structs
 */
class BusinessErrorList extends AbstractStructBase
{
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BusinessError[]
     */
    public $error;
    /**
     * Constructor method for BusinessErrorList
     * @uses BusinessErrorList::setError()
     * @param \StructType\BusinessError[] $error
     */
    public function __construct(array $error = array())
    {
        $this
            ->setError($error);
    }
    /**
     * Get error value
     * @return \StructType\BusinessError[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessError[] $error
     * @return \StructType\BusinessErrorList
     */
    public function setError(array $error = array())
    {
        foreach ($error as $businessErrorListErrorItem) {
            // validation for constraint: itemType
            if (!$businessErrorListErrorItem instanceof \StructType\BusinessError) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of \StructType\BusinessError, "%s" given', is_object($businessErrorListErrorItem) ? get_class($businessErrorListErrorItem) : gettype($businessErrorListErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \StructType\BusinessError $item
     * @return \StructType\BusinessErrorList
     */
    public function addToError(\StructType\BusinessError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BusinessError) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of \StructType\BusinessError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusinessErrorList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
