<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchOrigin StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о происхождении партии продукции.
 * @subpackage Structs
 */
class BatchOrigin extends AbstractStructBase
{
    /**
     * The productItem
     * Meta informations extracted from the WSDL
     * - documentation: Оригинальное наименование продукции (данное производителем).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductItem
     */
    public $productItem;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - documentation: Страна происхождения продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $country;
    /**
     * The producer
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о производителях продукции.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Producer[]
     */
    public $producer;
    /**
     * Constructor method for BatchOrigin
     * @uses BatchOrigin::setProductItem()
     * @uses BatchOrigin::setCountry()
     * @uses BatchOrigin::setProducer()
     * @param \StructType\ProductItem $productItem
     * @param \StructType\Country $country
     * @param \StructType\Producer[] $producer
     */
    public function __construct(\StructType\ProductItem $productItem = null, \StructType\Country $country = null, array $producer = array())
    {
        $this
            ->setProductItem($productItem)
            ->setCountry($country)
            ->setProducer($producer);
    }
    /**
     * Get productItem value
     * @return \StructType\ProductItem|null
     */
    public function getProductItem()
    {
        return $this->productItem;
    }
    /**
     * Set productItem value
     * @param \StructType\ProductItem $productItem
     * @return \StructType\BatchOrigin
     */
    public function setProductItem(\StructType\ProductItem $productItem = null)
    {
        $this->productItem = $productItem;
        return $this;
    }
    /**
     * Get country value
     * @return \StructType\Country|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param \StructType\Country $country
     * @return \StructType\BatchOrigin
     */
    public function setCountry(\StructType\Country $country = null)
    {
        $this->country = $country;
        return $this;
    }
    /**
     * Get producer value
     * @return \StructType\Producer[]|null
     */
    public function getProducer()
    {
        return $this->producer;
    }
    /**
     * Set producer value
     * @throws \InvalidArgumentException
     * @param \StructType\Producer[] $producer
     * @return \StructType\BatchOrigin
     */
    public function setProducer(array $producer = array())
    {
        foreach ($producer as $batchOriginProducerItem) {
            // validation for constraint: itemType
            if (!$batchOriginProducerItem instanceof \StructType\Producer) {
                throw new \InvalidArgumentException(sprintf('The producer property can only contain items of \StructType\Producer, "%s" given', is_object($batchOriginProducerItem) ? get_class($batchOriginProducerItem) : gettype($batchOriginProducerItem)), __LINE__);
            }
        }
        $this->producer = $producer;
        return $this;
    }
    /**
     * Add item to producer value
     * @throws \InvalidArgumentException
     * @param \StructType\Producer $item
     * @return \StructType\BatchOrigin
     */
    public function addToProducer(\StructType\Producer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Producer) {
            throw new \InvalidArgumentException(sprintf('The producer property can only contain items of \StructType\Producer, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->producer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BatchOrigin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
