<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Batch StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий партию груза.
 * @subpackage Structs
 */
class Batch extends AbstractStructBase
{
    /**
     * The productType
     * Meta informations extracted from the WSDL
     * - documentation: Тип продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Продукция.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Product
     */
    public $product;
    /**
     * The subProduct
     * Meta informations extracted from the WSDL
     * - documentation: Вид продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SubProduct
     */
    public $subProduct;
    /**
     * The productItem
     * Meta informations extracted from the WSDL
     * - documentation: Наименование продукции согласно номенклатуре владельца партии (склада).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductItem
     */
    public $productItem;
    /**
     * The volume
     * Meta informations extracted from the WSDL
     * - documentation: Объём груза. | Вещественный тип с ограничением числа знаков после запятой.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - fractionDigits: 6
     * @var float
     */
    public $volume;
    /**
     * The unit
     * Meta informations extracted from the WSDL
     * - documentation: Единица измерения объёма груза.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Unit
     */
    public $unit;
    /**
     * The dateOfProduction
     * Meta informations extracted from the WSDL
     * - documentation: Дата производства (выработки).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GoodsDate
     */
    public $dateOfProduction;
    /**
     * The expiryDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания срока годности.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GoodsDate
     */
    public $expiryDate;
    /**
     * The batchID
     * Meta informations extracted from the WSDL
     * - documentation: Уникальный идентификатор производственной партии продукции. | Тип, описывающий идентификатор.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 100
     * @var string[]
     */
    public $batchID;
    /**
     * The perishable
     * Meta informations extracted from the WSDL
     * - documentation: Скоропортящаяся продукция.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $perishable;
    /**
     * The origin
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о происхождении продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BatchOrigin
     */
    public $origin;
    /**
     * The lowGradeCargo
     * Meta informations extracted from the WSDL
     * - documentation: Является ли продукция некачественной.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $lowGradeCargo;
    /**
     * The packageList
     * Meta informations extracted from the WSDL
     * - documentation: Описание физической упаковки. Поддерживается указание многоуровневой упаковки и маркировки партии продукции. См. описание
     * типа vd:Package.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PackageList
     */
    public $packageList;
    /**
     * The owner
     * Meta informations extracted from the WSDL
     * - documentation: Собственник продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessEntity
     */
    public $owner;
    /**
     * The applicableClassifications
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительные характеристики партии.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BatchExtraInfo
     */
    public $applicableClassifications;
    /**
     * Constructor method for Batch
     * @uses Batch::setProductType()
     * @uses Batch::setProduct()
     * @uses Batch::setSubProduct()
     * @uses Batch::setProductItem()
     * @uses Batch::setVolume()
     * @uses Batch::setUnit()
     * @uses Batch::setDateOfProduction()
     * @uses Batch::setExpiryDate()
     * @uses Batch::setBatchID()
     * @uses Batch::setPerishable()
     * @uses Batch::setOrigin()
     * @uses Batch::setLowGradeCargo()
     * @uses Batch::setPackageList()
     * @uses Batch::setOwner()
     * @uses Batch::setApplicableClassifications()
     * @param string $productType
     * @param \StructType\Product $product
     * @param \StructType\SubProduct $subProduct
     * @param \StructType\ProductItem $productItem
     * @param float $volume
     * @param \StructType\Unit $unit
     * @param \StructType\GoodsDate $dateOfProduction
     * @param \StructType\GoodsDate $expiryDate
     * @param string[] $batchID
     * @param bool $perishable
     * @param \StructType\BatchOrigin $origin
     * @param bool $lowGradeCargo
     * @param \StructType\PackageList $packageList
     * @param \StructType\BusinessEntity $owner
     * @param \StructType\BatchExtraInfo $applicableClassifications
     */
    public function __construct($productType = null, \StructType\Product $product = null, \StructType\SubProduct $subProduct = null, \StructType\ProductItem $productItem = null, $volume = null, \StructType\Unit $unit = null, \StructType\GoodsDate $dateOfProduction = null, \StructType\GoodsDate $expiryDate = null, array $batchID = array(), $perishable = null, \StructType\BatchOrigin $origin = null, $lowGradeCargo = null, \StructType\PackageList $packageList = null, \StructType\BusinessEntity $owner = null, \StructType\BatchExtraInfo $applicableClassifications = null)
    {
        $this
            ->setProductType($productType)
            ->setProduct($product)
            ->setSubProduct($subProduct)
            ->setProductItem($productItem)
            ->setVolume($volume)
            ->setUnit($unit)
            ->setDateOfProduction($dateOfProduction)
            ->setExpiryDate($expiryDate)
            ->setBatchID($batchID)
            ->setPerishable($perishable)
            ->setOrigin($origin)
            ->setLowGradeCargo($lowGradeCargo)
            ->setPackageList($packageList)
            ->setOwner($owner)
            ->setApplicableClassifications($applicableClassifications);
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\Batch
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productType, implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get product value
     * @return \StructType\Product|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @param \StructType\Product $product
     * @return \StructType\Batch
     */
    public function setProduct(\StructType\Product $product = null)
    {
        $this->product = $product;
        return $this;
    }
    /**
     * Get subProduct value
     * @return \StructType\SubProduct|null
     */
    public function getSubProduct()
    {
        return $this->subProduct;
    }
    /**
     * Set subProduct value
     * @param \StructType\SubProduct $subProduct
     * @return \StructType\Batch
     */
    public function setSubProduct(\StructType\SubProduct $subProduct = null)
    {
        $this->subProduct = $subProduct;
        return $this;
    }
    /**
     * Get productItem value
     * @return \StructType\ProductItem|null
     */
    public function getProductItem()
    {
        return $this->productItem;
    }
    /**
     * Set productItem value
     * @param \StructType\ProductItem $productItem
     * @return \StructType\Batch
     */
    public function setProductItem(\StructType\ProductItem $productItem = null)
    {
        $this->productItem = $productItem;
        return $this;
    }
    /**
     * Get volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \StructType\Batch
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($volume) && strlen(substr($volume, strpos($volume, '.') + 1)) !== 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 6 fraction digits, "%d" given', strlen(substr($volume, strpos($volume, '.') + 1))), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get unit value
     * @return \StructType\Unit|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param \StructType\Unit $unit
     * @return \StructType\Batch
     */
    public function setUnit(\StructType\Unit $unit = null)
    {
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get dateOfProduction value
     * @return \StructType\GoodsDate|null
     */
    public function getDateOfProduction()
    {
        return $this->dateOfProduction;
    }
    /**
     * Set dateOfProduction value
     * @param \StructType\GoodsDate $dateOfProduction
     * @return \StructType\Batch
     */
    public function setDateOfProduction(\StructType\GoodsDate $dateOfProduction = null)
    {
        $this->dateOfProduction = $dateOfProduction;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return \StructType\GoodsDate|null
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param \StructType\GoodsDate $expiryDate
     * @return \StructType\Batch
     */
    public function setExpiryDate(\StructType\GoodsDate $expiryDate = null)
    {
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get batchID value
     * @return string[]|null
     */
    public function getBatchID()
    {
        return $this->batchID;
    }
    /**
     * Set batchID value
     * @throws \InvalidArgumentException
     * @param string[] $batchID
     * @return \StructType\Batch
     */
    public function setBatchID(array $batchID = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($batchID) && strlen($batchID) > 100) || (is_array($batchID) && count($batchID) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($batchID) ? strlen($batchID) : count($batchID)), __LINE__);
        }
        foreach ($batchID as $batchBatchIDItem) {
            // validation for constraint: itemType
            if (!is_string($batchBatchIDItem)) {
                throw new \InvalidArgumentException(sprintf('The batchID property can only contain items of token, "%s" given', is_object($batchBatchIDItem) ? get_class($batchBatchIDItem) : gettype($batchBatchIDItem)), __LINE__);
            }
        }
        $this->batchID = $batchID;
        return $this;
    }
    /**
     * Add item to batchID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Batch
     */
    public function addToBatchID($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 100) || (is_array($item) && count($item) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The batchID property can only contain items of token, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->batchID[] = $item;
        return $this;
    }
    /**
     * Get perishable value
     * @return bool|null
     */
    public function getPerishable()
    {
        return $this->perishable;
    }
    /**
     * Set perishable value
     * @param bool $perishable
     * @return \StructType\Batch
     */
    public function setPerishable($perishable = null)
    {
        // validation for constraint: boolean
        if (!is_null($perishable) && !is_bool($perishable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($perishable)), __LINE__);
        }
        $this->perishable = $perishable;
        return $this;
    }
    /**
     * Get origin value
     * @return \StructType\BatchOrigin|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param \StructType\BatchOrigin $origin
     * @return \StructType\Batch
     */
    public function setOrigin(\StructType\BatchOrigin $origin = null)
    {
        $this->origin = $origin;
        return $this;
    }
    /**
     * Get lowGradeCargo value
     * @return bool|null
     */
    public function getLowGradeCargo()
    {
        return $this->lowGradeCargo;
    }
    /**
     * Set lowGradeCargo value
     * @param bool $lowGradeCargo
     * @return \StructType\Batch
     */
    public function setLowGradeCargo($lowGradeCargo = null)
    {
        // validation for constraint: boolean
        if (!is_null($lowGradeCargo) && !is_bool($lowGradeCargo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($lowGradeCargo)), __LINE__);
        }
        $this->lowGradeCargo = $lowGradeCargo;
        return $this;
    }
    /**
     * Get packageList value
     * @return \StructType\PackageList|null
     */
    public function getPackageList()
    {
        return $this->packageList;
    }
    /**
     * Set packageList value
     * @param \StructType\PackageList $packageList
     * @return \StructType\Batch
     */
    public function setPackageList(\StructType\PackageList $packageList = null)
    {
        $this->packageList = $packageList;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\BusinessEntity|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\BusinessEntity $owner
     * @return \StructType\Batch
     */
    public function setOwner(\StructType\BusinessEntity $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get applicableClassifications value
     * @return \StructType\BatchExtraInfo|null
     */
    public function getApplicableClassifications()
    {
        return $this->applicableClassifications;
    }
    /**
     * Set applicableClassifications value
     * @param \StructType\BatchExtraInfo $applicableClassifications
     * @return \StructType\Batch
     */
    public function setApplicableClassifications(\StructType\BatchExtraInfo $applicableClassifications = null)
    {
        $this->applicableClassifications = $applicableClassifications;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Batch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
