<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BEModificationOperation StructType
 * Meta informations extracted from the WSDL
 * - documentation: Операция внесения изменений в реестр ХС.
 * @subpackage Structs
 */
class BEModificationOperation extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Тип операции
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The affectedList
     * Meta informations extracted from the WSDL
     * - documentation: Входящие записи для операции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessEntityList
     */
    public $affectedList;
    /**
     * The resultingList
     * Meta informations extracted from the WSDL
     * - documentation: Получаемые в результате операции записи.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessEntityList
     */
    public $resultingList;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - documentation: Причина изменений записи в реестре ХС. | Причина изменений записи в реестре ХС.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reason;
    /**
     * Constructor method for BEModificationOperation
     * @uses BEModificationOperation::setType()
     * @uses BEModificationOperation::setAffectedList()
     * @uses BEModificationOperation::setResultingList()
     * @uses BEModificationOperation::setReason()
     * @param string $type
     * @param \StructType\BusinessEntityList $affectedList
     * @param \StructType\BusinessEntityList $resultingList
     * @param string $reason
     */
    public function __construct($type = null, \StructType\BusinessEntityList $affectedList = null, \StructType\BusinessEntityList $resultingList = null, $reason = null)
    {
        $this
            ->setType($type)
            ->setAffectedList($affectedList)
            ->setResultingList($resultingList)
            ->setReason($reason);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\RegisterModificationType::valueIsValid()
     * @uses \EnumType\RegisterModificationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\BEModificationOperation
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RegisterModificationType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\RegisterModificationType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get affectedList value
     * @return \StructType\BusinessEntityList|null
     */
    public function getAffectedList()
    {
        return $this->affectedList;
    }
    /**
     * Set affectedList value
     * @param \StructType\BusinessEntityList $affectedList
     * @return \StructType\BEModificationOperation
     */
    public function setAffectedList(\StructType\BusinessEntityList $affectedList = null)
    {
        $this->affectedList = $affectedList;
        return $this;
    }
    /**
     * Get resultingList value
     * @return \StructType\BusinessEntityList|null
     */
    public function getResultingList()
    {
        return $this->resultingList;
    }
    /**
     * Set resultingList value
     * @param \StructType\BusinessEntityList $resultingList
     * @return \StructType\BEModificationOperation
     */
    public function setResultingList(\StructType\BusinessEntityList $resultingList = null)
    {
        $this->resultingList = $resultingList;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\BEModificationOperation
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BEModificationOperation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
