<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BEActivityLocationsModificationOperation StructType
 * Meta informations extracted from the WSDL
 * - documentation: Операция изменения связи между хозяйствующим субъектом и предприятиями.
 * @subpackage Structs
 */
class BEActivityLocationsModificationOperation extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Тип операции
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The businessEntity
     * Meta informations extracted from the WSDL
     * - documentation: Хозяйствующий субъект.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\BusinessEntity
     */
    public $businessEntity;
    /**
     * The activityLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\ActivityLocation[]
     */
    public $activityLocation;
    /**
     * Constructor method for BEActivityLocationsModificationOperation
     * @uses BEActivityLocationsModificationOperation::setType()
     * @uses BEActivityLocationsModificationOperation::setBusinessEntity()
     * @uses BEActivityLocationsModificationOperation::setActivityLocation()
     * @param string $type
     * @param \StructType\BusinessEntity $businessEntity
     * @param \StructType\ActivityLocation[] $activityLocation
     */
    public function __construct($type = null, \StructType\BusinessEntity $businessEntity = null, array $activityLocation = array())
    {
        $this
            ->setType($type)
            ->setBusinessEntity($businessEntity)
            ->setActivityLocation($activityLocation);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\RegisterModificationType::valueIsValid()
     * @uses \EnumType\RegisterModificationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\BEActivityLocationsModificationOperation
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RegisterModificationType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\RegisterModificationType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get businessEntity value
     * @return \StructType\BusinessEntity
     */
    public function getBusinessEntity()
    {
        return $this->businessEntity;
    }
    /**
     * Set businessEntity value
     * @param \StructType\BusinessEntity $businessEntity
     * @return \StructType\BEActivityLocationsModificationOperation
     */
    public function setBusinessEntity(\StructType\BusinessEntity $businessEntity = null)
    {
        $this->businessEntity = $businessEntity;
        return $this;
    }
    /**
     * Get activityLocation value
     * @return \StructType\ActivityLocation[]
     */
    public function getActivityLocation()
    {
        return $this->activityLocation;
    }
    /**
     * Set activityLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityLocation[] $activityLocation
     * @return \StructType\BEActivityLocationsModificationOperation
     */
    public function setActivityLocation(array $activityLocation = array())
    {
        foreach ($activityLocation as $bEActivityLocationsModificationOperationActivityLocationItem) {
            // validation for constraint: itemType
            if (!$bEActivityLocationsModificationOperationActivityLocationItem instanceof \StructType\ActivityLocation) {
                throw new \InvalidArgumentException(sprintf('The activityLocation property can only contain items of \StructType\ActivityLocation, "%s" given', is_object($bEActivityLocationsModificationOperationActivityLocationItem) ? get_class($bEActivityLocationsModificationOperationActivityLocationItem) : gettype($bEActivityLocationsModificationOperationActivityLocationItem)), __LINE__);
            }
        }
        $this->activityLocation = $activityLocation;
        return $this;
    }
    /**
     * Add item to activityLocation value
     * @throws \InvalidArgumentException
     * @param \StructType\ActivityLocation $item
     * @return \StructType\BEActivityLocationsModificationOperation
     */
    public function addToActivityLocation(\StructType\ActivityLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActivityLocation) {
            throw new \InvalidArgumentException(sprintf('The activityLocation property can only contain items of \StructType\ActivityLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->activityLocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BEActivityLocationsModificationOperation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
