<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationResultWrapper StructType
 * @subpackage Structs
 */
class ApplicationResultWrapper extends AbstractStructBase
{
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The encoding
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $encoding;
    /**
     * Constructor method for ApplicationResultWrapper
     * @uses ApplicationResultWrapper::setAny()
     * @uses ApplicationResultWrapper::setEncoding()
     * @param \DOMDocument $any
     * @param string $encoding
     */
    public function __construct(\DOMDocument $any = null, $encoding = null)
    {
        $this
            ->setAny($any)
            ->setEncoding($encoding);
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\ApplicationResultWrapper::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\ApplicationResultWrapper
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->encoding;
    }
    /**
     * Set encoding value
     * @uses \EnumType\ContentEncoding::valueIsValid()
     * @uses \EnumType\ContentEncoding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encoding
     * @return \StructType\ApplicationResultWrapper
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContentEncoding::valueIsValid($encoding)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $encoding, implode(', ', \EnumType\ContentEncoding::getValidValues())), __LINE__);
        }
        $this->encoding = $encoding;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ApplicationResultWrapper
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
