<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnimalMedicationEvent StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об обработке/иммунизации живого животного.
 * @subpackage Structs
 */
class AnimalMedicationEvent extends VeterinaryEvent
{
    /**
     * The disease
     * Meta informations extracted from the WSDL
     * - documentation: Заболевание
     * - minOccurs: 0
     * @var \StructType\AnimalDisease
     */
    public $disease;
    /**
     * The medicinalDrug
     * Meta informations extracted from the WSDL
     * - documentation: Препарат
     * - minOccurs: 0
     * @var \StructType\MedicinalDrug
     */
    public $medicinalDrug;
    /**
     * The effectiveBeforeDate
     * Meta informations extracted from the WSDL
     * - documentation: Срок действия препарата/вакцины. Указывается дата и время окончания срока действия.
     * - minOccurs: 0
     * @var string
     */
    public $effectiveBeforeDate;
    /**
     * Constructor method for AnimalMedicationEvent
     * @uses AnimalMedicationEvent::setDisease()
     * @uses AnimalMedicationEvent::setMedicinalDrug()
     * @uses AnimalMedicationEvent::setEffectiveBeforeDate()
     * @param \StructType\AnimalDisease $disease
     * @param \StructType\MedicinalDrug $medicinalDrug
     * @param string $effectiveBeforeDate
     */
    public function __construct(\StructType\AnimalDisease $disease = null, \StructType\MedicinalDrug $medicinalDrug = null, $effectiveBeforeDate = null)
    {
        $this
            ->setDisease($disease)
            ->setMedicinalDrug($medicinalDrug)
            ->setEffectiveBeforeDate($effectiveBeforeDate);
    }
    /**
     * Get disease value
     * @return \StructType\AnimalDisease|null
     */
    public function getDisease()
    {
        return $this->disease;
    }
    /**
     * Set disease value
     * @param \StructType\AnimalDisease $disease
     * @return \StructType\AnimalMedicationEvent
     */
    public function setDisease(\StructType\AnimalDisease $disease = null)
    {
        $this->disease = $disease;
        return $this;
    }
    /**
     * Get medicinalDrug value
     * @return \StructType\MedicinalDrug|null
     */
    public function getMedicinalDrug()
    {
        return $this->medicinalDrug;
    }
    /**
     * Set medicinalDrug value
     * @param \StructType\MedicinalDrug $medicinalDrug
     * @return \StructType\AnimalMedicationEvent
     */
    public function setMedicinalDrug(\StructType\MedicinalDrug $medicinalDrug = null)
    {
        $this->medicinalDrug = $medicinalDrug;
        return $this;
    }
    /**
     * Get effectiveBeforeDate value
     * @return string|null
     */
    public function getEffectiveBeforeDate()
    {
        return $this->effectiveBeforeDate;
    }
    /**
     * Set effectiveBeforeDate value
     * @param string $effectiveBeforeDate
     * @return \StructType\AnimalMedicationEvent
     */
    public function setEffectiveBeforeDate($effectiveBeforeDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveBeforeDate) && !is_string($effectiveBeforeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveBeforeDate)), __LINE__);
        }
        $this->effectiveBeforeDate = $effectiveBeforeDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnimalMedicationEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
