<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Country
     */
    public $country;
    /**
     * The federalDistrict
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FederalDistrict
     */
    public $federalDistrict;
    /**
     * The region
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Region
     */
    public $region;
    /**
     * The district
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\District
     */
    public $district;
    /**
     * The locality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Locality
     */
    public $locality;
    /**
     * The subLocality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Locality
     */
    public $subLocality;
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Street
     */
    public $street;
    /**
     * The house
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип с ограничением максимальной длины.
     * - maxLength: 255
     * @var string
     */
    public $house;
    /**
     * The building
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип с ограничением максимальной длины.
     * - maxLength: 255
     * @var string
     */
    public $building;
    /**
     * The room
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип с ограничением максимальной длины.
     * - maxLength: 255
     * @var string
     */
    public $room;
    /**
     * The postIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип с ограничением максимальной длины.
     * - maxLength: 255
     * @var string
     */
    public $postIndex;
    /**
     * The postBox
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип с ограничением максимальной длины.
     * - maxLength: 255
     * @var string
     */
    public $postBox;
    /**
     * The additionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип (нормализованная строка) без ограничения максимальной длины.
     * @var string
     */
    public $additionalInfo;
    /**
     * The addressView
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип (нормализованная строка) без ограничения максимальной длины.
     * @var string
     */
    public $addressView;
    /**
     * The enAddressView
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип (нормализованная строка) без ограничения максимальной длины.
     * @var string
     */
    public $enAddressView;
    /**
     * Constructor method for Address
     * @uses Address::setCountry()
     * @uses Address::setFederalDistrict()
     * @uses Address::setRegion()
     * @uses Address::setDistrict()
     * @uses Address::setLocality()
     * @uses Address::setSubLocality()
     * @uses Address::setStreet()
     * @uses Address::setHouse()
     * @uses Address::setBuilding()
     * @uses Address::setRoom()
     * @uses Address::setPostIndex()
     * @uses Address::setPostBox()
     * @uses Address::setAdditionalInfo()
     * @uses Address::setAddressView()
     * @uses Address::setEnAddressView()
     * @param \StructType\Country $country
     * @param \StructType\FederalDistrict $federalDistrict
     * @param \StructType\Region $region
     * @param \StructType\District $district
     * @param \StructType\Locality $locality
     * @param \StructType\Locality $subLocality
     * @param \StructType\Street $street
     * @param string $house
     * @param string $building
     * @param string $room
     * @param string $postIndex
     * @param string $postBox
     * @param string $additionalInfo
     * @param string $addressView
     * @param string $enAddressView
     */
    public function __construct(\StructType\Country $country = null, \StructType\FederalDistrict $federalDistrict = null, \StructType\Region $region = null, \StructType\District $district = null, \StructType\Locality $locality = null, \StructType\Locality $subLocality = null, \StructType\Street $street = null, $house = null, $building = null, $room = null, $postIndex = null, $postBox = null, $additionalInfo = null, $addressView = null, $enAddressView = null)
    {
        $this
            ->setCountry($country)
            ->setFederalDistrict($federalDistrict)
            ->setRegion($region)
            ->setDistrict($district)
            ->setLocality($locality)
            ->setSubLocality($subLocality)
            ->setStreet($street)
            ->setHouse($house)
            ->setBuilding($building)
            ->setRoom($room)
            ->setPostIndex($postIndex)
            ->setPostBox($postBox)
            ->setAdditionalInfo($additionalInfo)
            ->setAddressView($addressView)
            ->setEnAddressView($enAddressView);
    }
    /**
     * Get country value
     * @return \StructType\Country|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param \StructType\Country $country
     * @return \StructType\Address
     */
    public function setCountry(\StructType\Country $country = null)
    {
        $this->country = $country;
        return $this;
    }
    /**
     * Get federalDistrict value
     * @return \StructType\FederalDistrict|null
     */
    public function getFederalDistrict()
    {
        return $this->federalDistrict;
    }
    /**
     * Set federalDistrict value
     * @param \StructType\FederalDistrict $federalDistrict
     * @return \StructType\Address
     */
    public function setFederalDistrict(\StructType\FederalDistrict $federalDistrict = null)
    {
        $this->federalDistrict = $federalDistrict;
        return $this;
    }
    /**
     * Get region value
     * @return \StructType\Region|null
     */
    public function getRegion()
    {
        return $this->region;
    }
    /**
     * Set region value
     * @param \StructType\Region $region
     * @return \StructType\Address
     */
    public function setRegion(\StructType\Region $region = null)
    {
        $this->region = $region;
        return $this;
    }
    /**
     * Get district value
     * @return \StructType\District|null
     */
    public function getDistrict()
    {
        return $this->district;
    }
    /**
     * Set district value
     * @param \StructType\District $district
     * @return \StructType\Address
     */
    public function setDistrict(\StructType\District $district = null)
    {
        $this->district = $district;
        return $this;
    }
    /**
     * Get locality value
     * @return \StructType\Locality|null
     */
    public function getLocality()
    {
        return $this->locality;
    }
    /**
     * Set locality value
     * @param \StructType\Locality $locality
     * @return \StructType\Address
     */
    public function setLocality(\StructType\Locality $locality = null)
    {
        $this->locality = $locality;
        return $this;
    }
    /**
     * Get subLocality value
     * @return \StructType\Locality|null
     */
    public function getSubLocality()
    {
        return $this->subLocality;
    }
    /**
     * Set subLocality value
     * @param \StructType\Locality $subLocality
     * @return \StructType\Address
     */
    public function setSubLocality(\StructType\Locality $subLocality = null)
    {
        $this->subLocality = $subLocality;
        return $this;
    }
    /**
     * Get street value
     * @return \StructType\Street|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param \StructType\Street $street
     * @return \StructType\Address
     */
    public function setStreet(\StructType\Street $street = null)
    {
        $this->street = $street;
        return $this;
    }
    /**
     * Get house value
     * @return string|null
     */
    public function getHouse()
    {
        return $this->house;
    }
    /**
     * Set house value
     * @param string $house
     * @return \StructType\Address
     */
    public function setHouse($house = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($house) && strlen($house) > 255) || (is_array($house) && count($house) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($house) ? strlen($house) : count($house)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($house) && !is_string($house)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($house)), __LINE__);
        }
        $this->house = $house;
        return $this;
    }
    /**
     * Get building value
     * @return string|null
     */
    public function getBuilding()
    {
        return $this->building;
    }
    /**
     * Set building value
     * @param string $building
     * @return \StructType\Address
     */
    public function setBuilding($building = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($building) && strlen($building) > 255) || (is_array($building) && count($building) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($building) ? strlen($building) : count($building)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($building) && !is_string($building)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($building)), __LINE__);
        }
        $this->building = $building;
        return $this;
    }
    /**
     * Get room value
     * @return string|null
     */
    public function getRoom()
    {
        return $this->room;
    }
    /**
     * Set room value
     * @param string $room
     * @return \StructType\Address
     */
    public function setRoom($room = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($room) && strlen($room) > 255) || (is_array($room) && count($room) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($room) ? strlen($room) : count($room)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($room)), __LINE__);
        }
        $this->room = $room;
        return $this;
    }
    /**
     * Get postIndex value
     * @return string|null
     */
    public function getPostIndex()
    {
        return $this->postIndex;
    }
    /**
     * Set postIndex value
     * @param string $postIndex
     * @return \StructType\Address
     */
    public function setPostIndex($postIndex = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postIndex) && strlen($postIndex) > 255) || (is_array($postIndex) && count($postIndex) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($postIndex) ? strlen($postIndex) : count($postIndex)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postIndex) && !is_string($postIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postIndex)), __LINE__);
        }
        $this->postIndex = $postIndex;
        return $this;
    }
    /**
     * Get postBox value
     * @return string|null
     */
    public function getPostBox()
    {
        return $this->postBox;
    }
    /**
     * Set postBox value
     * @param string $postBox
     * @return \StructType\Address
     */
    public function setPostBox($postBox = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postBox) && strlen($postBox) > 255) || (is_array($postBox) && count($postBox) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($postBox) ? strlen($postBox) : count($postBox)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postBox) && !is_string($postBox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postBox)), __LINE__);
        }
        $this->postBox = $postBox;
        return $this;
    }
    /**
     * Get additionalInfo value
     * @return string|null
     */
    public function getAdditionalInfo()
    {
        return $this->additionalInfo;
    }
    /**
     * Set additionalInfo value
     * @param string $additionalInfo
     * @return \StructType\Address
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        // validation for constraint: string
        if (!is_null($additionalInfo) && !is_string($additionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additionalInfo)), __LINE__);
        }
        $this->additionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get addressView value
     * @return string|null
     */
    public function getAddressView()
    {
        return $this->addressView;
    }
    /**
     * Set addressView value
     * @param string $addressView
     * @return \StructType\Address
     */
    public function setAddressView($addressView = null)
    {
        // validation for constraint: string
        if (!is_null($addressView) && !is_string($addressView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressView)), __LINE__);
        }
        $this->addressView = $addressView;
        return $this;
    }
    /**
     * Get enAddressView value
     * @return string|null
     */
    public function getEnAddressView()
    {
        return $this->enAddressView;
    }
    /**
     * Set enAddressView value
     * @param string $enAddressView
     * @return \StructType\Address
     */
    public function setEnAddressView($enAddressView = null)
    {
        // validation for constraint: string
        if (!is_null($enAddressView) && !is_string($enAddressView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enAddressView)), __LINE__);
        }
        $this->enAddressView = $enAddressView;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
