<?php

namespace EnumType;

/**
 * This class stands for VetDocumentStatus EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Статус ветсертификата.
 * @subpackage Enumerations
 */
class VetDocumentStatus
{
    /**
     * Constant for value 'CREATED'
     * @return string 'CREATED'
     */
    const VALUE_CREATED = 'CREATED';
    /**
     * Constant for value 'CONFIRMED'
     * @return string 'CONFIRMED'
     */
    const VALUE_CONFIRMED = 'CONFIRMED';
    /**
     * Constant for value 'WITHDRAWN'
     * @return string 'WITHDRAWN'
     */
    const VALUE_WITHDRAWN = 'WITHDRAWN';
    /**
     * Constant for value 'UTILIZED'
     * @return string 'UTILIZED'
     */
    const VALUE_UTILIZED = 'UTILIZED';
    /**
     * Constant for value 'FINALIZED'
     * @return string 'FINALIZED'
     */
    const VALUE_FINALIZED = 'FINALIZED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CREATED
     * @uses self::VALUE_CONFIRMED
     * @uses self::VALUE_WITHDRAWN
     * @uses self::VALUE_UTILIZED
     * @uses self::VALUE_FINALIZED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CREATED,
            self::VALUE_CONFIRMED,
            self::VALUE_WITHDRAWN,
            self::VALUE_UTILIZED,
            self::VALUE_FINALIZED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
