<?php

namespace EnumType;

/**
 * This class stands for StockEntryBlankFilter EnumType
 * @subpackage Enumerations
 */
class StockEntryBlankFilter
{
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Constant for value 'BLANK'
     * @return string 'BLANK'
     */
    const VALUE_BLANK = 'BLANK';
    /**
     * Constant for value 'NOT_BLANK'
     * @return string 'NOT_BLANK'
     */
    const VALUE_NOT_BLANK = 'NOT_BLANK';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_BLANK
     * @uses self::VALUE_NOT_BLANK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_BLANK,
            self::VALUE_NOT_BLANK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
