<?php

namespace EnumType;

/**
 * This class stands for ResearchResult EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Результат лабораторного исследования/ВСЭ
 * @subpackage Enumerations
 */
class ResearchResult
{
    /**
     * Constant for value 'UNKNOWN'
     * @return string 'UNKNOWN'
     */
    const VALUE_UNKNOWN = 'UNKNOWN';
    /**
     * Constant for value 'UNDEFINED'
     * @return string 'UNDEFINED'
     */
    const VALUE_UNDEFINED = 'UNDEFINED';
    /**
     * Constant for value 'POSITIVE'
     * @return string 'POSITIVE'
     */
    const VALUE_POSITIVE = 'POSITIVE';
    /**
     * Constant for value 'NEGATIVE'
     * @return string 'NEGATIVE'
     */
    const VALUE_NEGATIVE = 'NEGATIVE';
    /**
     * Constant for value 'UNFULFILLED'
     * @return string 'UNFULFILLED'
     */
    const VALUE_UNFULFILLED = 'UNFULFILLED';
    /**
     * Constant for value 'VSERAW'
     * @return string 'VSERAW'
     */
    const VALUE_VSERAW = 'VSERAW';
    /**
     * Constant for value 'VSEFULL'
     * @return string 'VSEFULL'
     */
    const VALUE_VSEFULL = 'VSEFULL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_UNDEFINED
     * @uses self::VALUE_POSITIVE
     * @uses self::VALUE_NEGATIVE
     * @uses self::VALUE_UNFULFILLED
     * @uses self::VALUE_VSERAW
     * @uses self::VALUE_VSEFULL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_UNDEFINED,
            self::VALUE_POSITIVE,
            self::VALUE_NEGATIVE,
            self::VALUE_UNFULFILLED,
            self::VALUE_VSERAW,
            self::VALUE_VSEFULL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
