<?php

namespace EnumType;

/**
 * This class stands for ProductMarkingClass EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий тип маркировки.
 * @subpackage Enumerations
 */
class ProductMarkingClass
{
    /**
     * Constant for value 'UNDEFINED'
     * @return string 'UNDEFINED'
     */
    const VALUE_UNDEFINED = 'UNDEFINED';
    /**
     * Constant for value 'BN'
     * @return string 'BN'
     */
    const VALUE_BN = 'BN';
    /**
     * Constant for value 'SSCC'
     * @return string 'SSCC'
     */
    const VALUE_SSCC = 'SSCC';
    /**
     * Constant for value 'EAN8'
     * @return string 'EAN8'
     */
    const VALUE_EAN_8 = 'EAN8';
    /**
     * Constant for value 'EAN13'
     * @return string 'EAN13'
     */
    const VALUE_EAN_13 = 'EAN13';
    /**
     * Constant for value 'EAN128'
     * @return string 'EAN128'
     */
    const VALUE_EAN_128 = 'EAN128';
    /**
     * Constant for value 'BUNDLE'
     * @return string 'BUNDLE'
     */
    const VALUE_BUNDLE = 'BUNDLE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNDEFINED
     * @uses self::VALUE_BN
     * @uses self::VALUE_SSCC
     * @uses self::VALUE_EAN_8
     * @uses self::VALUE_EAN_13
     * @uses self::VALUE_EAN_128
     * @uses self::VALUE_BUNDLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNDEFINED,
            self::VALUE_BN,
            self::VALUE_SSCC,
            self::VALUE_EAN_8,
            self::VALUE_EAN_13,
            self::VALUE_EAN_128,
            self::VALUE_BUNDLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
