<?php

namespace EnumType;

/**
 * This class stands for ProcessingProcedureType EnumType
 * @subpackage Enumerations
 */
class ProcessingProcedureType
{
    /**
     * Constant for value '7'
     * @return string '7'
     */
    const VALUE_7 = '7';
    /**
     * Constant for value '12'
     * @return string '12'
     */
    const VALUE_12 = '12';
    /**
     * Constant for value '13'
     * @return string '13'
     */
    const VALUE_13 = '13';
    /**
     * Constant for value '34'
     * @return string '34'
     */
    const VALUE_34 = '34';
    /**
     * Constant for value '35'
     * @return string '35'
     */
    const VALUE_35 = '35';
    /**
     * Constant for value '37'
     * @return string '37'
     */
    const VALUE_37 = '37';
    /**
     * Constant for value '39'
     * @return string '39'
     */
    const VALUE_39 = '39';
    /**
     * Constant for value '40'
     * @return string '40'
     */
    const VALUE_40 = '40';
    /**
     * Constant for value '43'
     * @return string '43'
     */
    const VALUE_43 = '43';
    /**
     * Constant for value '51'
     * @return string '51'
     */
    const VALUE_51 = '51';
    /**
     * Constant for value '73'
     * @return string '73'
     */
    const VALUE_73 = '73';
    /**
     * Constant for value '95'
     * @return string '95'
     */
    const VALUE_95 = '95';
    /**
     * Constant for value '101'
     * @return string '101'
     */
    const VALUE_101 = '101';
    /**
     * Constant for value '102'
     * @return string '102'
     */
    const VALUE_102 = '102';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_7
     * @uses self::VALUE_12
     * @uses self::VALUE_13
     * @uses self::VALUE_34
     * @uses self::VALUE_35
     * @uses self::VALUE_37
     * @uses self::VALUE_39
     * @uses self::VALUE_40
     * @uses self::VALUE_43
     * @uses self::VALUE_51
     * @uses self::VALUE_73
     * @uses self::VALUE_95
     * @uses self::VALUE_101
     * @uses self::VALUE_102
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_7,
            self::VALUE_12,
            self::VALUE_13,
            self::VALUE_34,
            self::VALUE_35,
            self::VALUE_37,
            self::VALUE_39,
            self::VALUE_40,
            self::VALUE_43,
            self::VALUE_51,
            self::VALUE_73,
            self::VALUE_95,
            self::VALUE_101,
            self::VALUE_102,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
