<?php

namespace EnumType;

/**
 * This class stands for DocumentNature EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Природа (тип) документа
 * @subpackage Enumerations
 */
class DocumentNature
{
    /**
     * Constant for value 'ELECTRONIC'
     * @return string 'ELECTRONIC'
     */
    const VALUE_ELECTRONIC = 'ELECTRONIC';
    /**
     * Constant for value 'PAPER'
     * @return string 'PAPER'
     */
    const VALUE_PAPER = 'PAPER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ELECTRONIC
     * @uses self::VALUE_PAPER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ELECTRONIC,
            self::VALUE_PAPER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
