<?php

namespace EnumType;

/**
 * This class stands for AnimalSpentPeriod EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Сколько времени животные находились на территории ТС.
 * @subpackage Enumerations
 */
class AnimalSpentPeriod
{
    /**
     * Constant for value 'FROM_BIRTH'
     * @return string 'FROM_BIRTH'
     */
    const VALUE_FROM_BIRTH = 'FROM_BIRTH';
    /**
     * Constant for value 'NOT_LESS_SIX_MONTHS'
     * @return string 'NOT_LESS_SIX_MONTHS'
     */
    const VALUE_NOT_LESS_SIX_MONTHS = 'NOT_LESS_SIX_MONTHS';
    /**
     * Constant for value 'IN_MONTHS'
     * @return string 'IN_MONTHS'
     */
    const VALUE_IN_MONTHS = 'IN_MONTHS';
    /**
     * Constant for value 'ZERO'
     * @return string 'ZERO'
     */
    const VALUE_ZERO = 'ZERO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FROM_BIRTH
     * @uses self::VALUE_NOT_LESS_SIX_MONTHS
     * @uses self::VALUE_IN_MONTHS
     * @uses self::VALUE_ZERO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FROM_BIRTH,
            self::VALUE_NOT_LESS_SIX_MONTHS,
            self::VALUE_IN_MONTHS,
            self::VALUE_ZERO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
