<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserField StructType
 * Meta informations extracted from the WSDL
 * - documentation: Data in a user field. Specify the data value in the appropriate xxValue property (TextValue, NumberValue...), then specify in the ValueType property, the xxValue property type (TextValueKind, NumberValueKind...).
 * - nillable: true
 * - type: tns:UserField
 * @subpackage Structs
 */
class UserField extends AbstractStructBase
{
    /**
     * The BooleanValue
     * Meta informations extracted from the WSDL
     * - documentation: Value of type Boolean defined by the user - Related to column CBR [MCHPSUTILISATDATA.MUD_VALCHAMP].
     * - minOccurs: 0
     * @var bool
     */
    public $BooleanValue;
    /**
     * The DateValue
     * Meta informations extracted from the WSDL
     * - documentation: Value of type date defined by the user - Related to column CBR [MCHPSUTILISATDATA.MUD_VALCHAMP]. The date passed in must not specify time information.
     * - minOccurs: 0
     * @var string
     */
    public $DateValue;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: User field identifier - Related to column CBR [MCHPSUTILISAT.MUD_IDCHAMP].
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The ListElementValue
     * Meta informations extracted from the WSDL
     * - documentation: Value of type list element defined by the user - Related to column CBR [MCHPSUTILISATDATA.MUD_VALCHAMP].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ListElementValue;
    /**
     * The NumberValue
     * Meta informations extracted from the WSDL
     * - documentation: Value of type number defined by the user - Related to column CBR [MCHPSUTILISATDATA.MUD_VALCHAMP].
     * - minOccurs: 0
     * @var float
     */
    public $NumberValue;
    /**
     * The TextValue
     * Meta informations extracted from the WSDL
     * - documentation: Value of type text defined by the user - Related to column CBR [MCHPSUTILISATDATA.MUD_VALCHAMP].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TextValue;
    /**
     * The ValueType
     * Meta informations extracted from the WSDL
     * - documentation: Data type of user field - Related to column CBR [MCHPSUTILISAT.MUC_TYPESAISIE].
     * - minOccurs: 0
     * @var string
     */
    public $ValueType;
    /**
     * Constructor method for UserField
     * @uses UserField::setBooleanValue()
     * @uses UserField::setDateValue()
     * @uses UserField::setId()
     * @uses UserField::setListElementValue()
     * @uses UserField::setNumberValue()
     * @uses UserField::setTextValue()
     * @uses UserField::setValueType()
     * @param bool $booleanValue
     * @param string $dateValue
     * @param int $id
     * @param string $listElementValue
     * @param float $numberValue
     * @param string $textValue
     * @param string $valueType
     */
    public function __construct($booleanValue = null, $dateValue = null, $id = null, $listElementValue = null, $numberValue = null, $textValue = null, $valueType = null)
    {
        $this
            ->setBooleanValue($booleanValue)
            ->setDateValue($dateValue)
            ->setId($id)
            ->setListElementValue($listElementValue)
            ->setNumberValue($numberValue)
            ->setTextValue($textValue)
            ->setValueType($valueType);
    }
    /**
     * Get BooleanValue value
     * @return bool|null
     */
    public function getBooleanValue()
    {
        return $this->BooleanValue;
    }
    /**
     * Set BooleanValue value
     * @param bool $booleanValue
     * @return \StructType\UserField
     */
    public function setBooleanValue($booleanValue = null)
    {
        $this->BooleanValue = $booleanValue;
        return $this;
    }
    /**
     * Get DateValue value
     * @return string|null
     */
    public function getDateValue()
    {
        return $this->DateValue;
    }
    /**
     * Set DateValue value
     * @param string $dateValue
     * @return \StructType\UserField
     */
    public function setDateValue($dateValue = null)
    {
        // validation for constraint: string
        if (!is_null($dateValue) && !is_string($dateValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateValue)), __LINE__);
        }
        $this->DateValue = $dateValue;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\UserField
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ListElementValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getListElementValue()
    {
        return isset($this->ListElementValue) ? $this->ListElementValue : null;
    }
    /**
     * Set ListElementValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $listElementValue
     * @return \StructType\UserField
     */
    public function setListElementValue($listElementValue = null)
    {
        // validation for constraint: string
        if (!is_null($listElementValue) && !is_string($listElementValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listElementValue)), __LINE__);
        }
        if (is_null($listElementValue) || (is_array($listElementValue) && empty($listElementValue))) {
            unset($this->ListElementValue);
        } else {
            $this->ListElementValue = $listElementValue;
        }
        return $this;
    }
    /**
     * Get NumberValue value
     * @return float|null
     */
    public function getNumberValue()
    {
        return $this->NumberValue;
    }
    /**
     * Set NumberValue value
     * @param float $numberValue
     * @return \StructType\UserField
     */
    public function setNumberValue($numberValue = null)
    {
        $this->NumberValue = $numberValue;
        return $this;
    }
    /**
     * Get TextValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTextValue()
    {
        return isset($this->TextValue) ? $this->TextValue : null;
    }
    /**
     * Set TextValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $textValue
     * @return \StructType\UserField
     */
    public function setTextValue($textValue = null)
    {
        // validation for constraint: string
        if (!is_null($textValue) && !is_string($textValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($textValue)), __LINE__);
        }
        if (is_null($textValue) || (is_array($textValue) && empty($textValue))) {
            unset($this->TextValue);
        } else {
            $this->TextValue = $textValue;
        }
        return $this;
    }
    /**
     * Get ValueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->ValueType;
    }
    /**
     * Set ValueType value
     * @uses \EnumType\UserFieldKind::valueIsValid()
     * @uses \EnumType\UserFieldKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valueType
     * @return \StructType\UserField
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UserFieldKind::valueIsValid($valueType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $valueType, implode(', ', \EnumType\UserFieldKind::getValidValues())), __LINE__);
        }
        $this->ValueType = $valueType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
