<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NationalityDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Information about nationality.
 * - nillable: true
 * - type: tns:NationalityDataType
 * @subpackage Structs
 */
class NationalityDataType extends AbstractStructBase
{
    /**
     * The ISO2
     * Meta informations extracted from the WSDL
     * - documentation: ISO2 nationality code. - Related to column CBR [PAYS.PY_CODEISO2].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ISO2;
    /**
     * The ISO3
     * Meta informations extracted from the WSDL
     * - documentation: ISO3 nationality code. - Related to column CBR [PAYS.PY_CODEINSEE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ISO3;
    /**
     * The ISO3Num
     * Meta informations extracted from the WSDL
     * - documentation: Numerical ISO3 nationality code. - Related to column CBR [PAYS.PY_CODEBANCAIRE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ISO3Num;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Nationality ID. - Related to column CBR [TIERS.T_NATIONALITE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * The Label
     * Meta informations extracted from the WSDL
     * - documentation: Nationality label - Related to column CBR [PAYS.PY_LIBELLE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * Constructor method for NationalityDataType
     * @uses NationalityDataType::setISO2()
     * @uses NationalityDataType::setISO3()
     * @uses NationalityDataType::setISO3Num()
     * @uses NationalityDataType::setId()
     * @uses NationalityDataType::setLabel()
     * @param string $iSO2
     * @param string $iSO3
     * @param string $iSO3Num
     * @param string $id
     * @param string $label
     */
    public function __construct($iSO2 = null, $iSO3 = null, $iSO3Num = null, $id = null, $label = null)
    {
        $this
            ->setISO2($iSO2)
            ->setISO3($iSO3)
            ->setISO3Num($iSO3Num)
            ->setId($id)
            ->setLabel($label);
    }
    /**
     * Get ISO2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getISO2()
    {
        return isset($this->ISO2) ? $this->ISO2 : null;
    }
    /**
     * Set ISO2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iSO2
     * @return \StructType\NationalityDataType
     */
    public function setISO2($iSO2 = null)
    {
        // validation for constraint: string
        if (!is_null($iSO2) && !is_string($iSO2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSO2)), __LINE__);
        }
        if (is_null($iSO2) || (is_array($iSO2) && empty($iSO2))) {
            unset($this->ISO2);
        } else {
            $this->ISO2 = $iSO2;
        }
        return $this;
    }
    /**
     * Get ISO3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getISO3()
    {
        return isset($this->ISO3) ? $this->ISO3 : null;
    }
    /**
     * Set ISO3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iSO3
     * @return \StructType\NationalityDataType
     */
    public function setISO3($iSO3 = null)
    {
        // validation for constraint: string
        if (!is_null($iSO3) && !is_string($iSO3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSO3)), __LINE__);
        }
        if (is_null($iSO3) || (is_array($iSO3) && empty($iSO3))) {
            unset($this->ISO3);
        } else {
            $this->ISO3 = $iSO3;
        }
        return $this;
    }
    /**
     * Get ISO3Num value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getISO3Num()
    {
        return isset($this->ISO3Num) ? $this->ISO3Num : null;
    }
    /**
     * Set ISO3Num value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iSO3Num
     * @return \StructType\NationalityDataType
     */
    public function setISO3Num($iSO3Num = null)
    {
        // validation for constraint: string
        if (!is_null($iSO3Num) && !is_string($iSO3Num)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSO3Num)), __LINE__);
        }
        if (is_null($iSO3Num) || (is_array($iSO3Num) && empty($iSO3Num))) {
            unset($this->ISO3Num);
        } else {
            $this->ISO3Num = $iSO3Num;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \StructType\NationalityDataType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \StructType\NationalityDataType
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NationalityDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
