<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSearchDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Possible customer search criteria.
 * - nillable: true
 * - type: tns:CustomerSearchDataType
 * @subpackage Structs
 */
class CustomerSearchDataType extends CustomerDataBase
{
    /**
     * The BirthDateData
     * Meta informations extracted from the WSDL
     * - documentation: Elements of the customer's birth date.
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BirthDateDataType
     */
    public $BirthDateData;
    /**
     * The Closed
     * Meta informations extracted from the WSDL
     * - documentation: [Optional] - Customer closed. - Related to column CBR [TIERS.T_FERME].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Closed;
    /**
     * The CreationStoreId
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of the store where the customer was created. - Related to column CBR [TIERS.T_ETABCREATION].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationStoreId;
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - documentation: Customer's ID. - Related to column CBR [TIERS.T_TIERS].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerId;
    /**
     * The CustomerReference
     * Meta informations extracted from the WSDL
     * - documentation: Search identifier based customer search priorities.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerReference;
    /**
     * The FiscalId
     * Meta informations extracted from the WSDL
     * - documentation: Customer TIN or VAT identification number. - Related to column CBR [TIERS.T_NIF].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FiscalId;
    /**
     * The IsCustomer
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2016/11 - V1201] [Optional] - ??? Client. ??? - Related to column CBR [TIERS.T_NATUREAUXI].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCustomer;
    /**
     * The IsProspect
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2016/11 - V1201] [Optional] - ??? Prospect. ??? - Related to column CBR [TIERS.T_NATUREAUXI].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsProspect;
    /**
     * The MaxNumberOfCustomers
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2014/08 - V1105] [Optional] - Maximum number of customers returned. If not specified, maximum 5 customers are returned.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxNumberOfCustomers;
    /**
     * The NationalityData
     * Meta informations extracted from the WSDL
     * - documentation: Customer's nationality data.
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NationalityDataType
     */
    public $NationalityData;
    /**
     * The PassportNumber
     * Meta informations extracted from the WSDL
     * - documentation: Customer's passport. - Related to column CBR [TIERS.T_PASSEPORT].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassportNumber;
    /**
     * Constructor method for CustomerSearchDataType
     * @uses CustomerSearchDataType::setBirthDateData()
     * @uses CustomerSearchDataType::setClosed()
     * @uses CustomerSearchDataType::setCreationStoreId()
     * @uses CustomerSearchDataType::setCustomerId()
     * @uses CustomerSearchDataType::setCustomerReference()
     * @uses CustomerSearchDataType::setFiscalId()
     * @uses CustomerSearchDataType::setIsCustomer()
     * @uses CustomerSearchDataType::setIsProspect()
     * @uses CustomerSearchDataType::setMaxNumberOfCustomers()
     * @uses CustomerSearchDataType::setNationalityData()
     * @uses CustomerSearchDataType::setPassportNumber()
     * @param \StructType\BirthDateDataType $birthDateData
     * @param bool $closed
     * @param string $creationStoreId
     * @param string $customerId
     * @param string $customerReference
     * @param string $fiscalId
     * @param bool $isCustomer
     * @param bool $isProspect
     * @param int $maxNumberOfCustomers
     * @param \StructType\NationalityDataType $nationalityData
     * @param string $passportNumber
     */
    public function __construct(\StructType\BirthDateDataType $birthDateData = null, $closed = null, $creationStoreId = null, $customerId = null, $customerReference = null, $fiscalId = null, $isCustomer = null, $isProspect = null, $maxNumberOfCustomers = null, \StructType\NationalityDataType $nationalityData = null, $passportNumber = null)
    {
        $this
            ->setBirthDateData($birthDateData)
            ->setClosed($closed)
            ->setCreationStoreId($creationStoreId)
            ->setCustomerId($customerId)
            ->setCustomerReference($customerReference)
            ->setFiscalId($fiscalId)
            ->setIsCustomer($isCustomer)
            ->setIsProspect($isProspect)
            ->setMaxNumberOfCustomers($maxNumberOfCustomers)
            ->setNationalityData($nationalityData)
            ->setPassportNumber($passportNumber);
    }
    /**
     * Get BirthDateData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BirthDateDataType|null
     */
    public function getBirthDateData()
    {
        return isset($this->BirthDateData) ? $this->BirthDateData : null;
    }
    /**
     * Set BirthDateData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BirthDateDataType $birthDateData
     * @return \StructType\CustomerSearchDataType
     */
    public function setBirthDateData(\StructType\BirthDateDataType $birthDateData = null)
    {
        if (is_null($birthDateData) || (is_array($birthDateData) && empty($birthDateData))) {
            unset($this->BirthDateData);
        } else {
            $this->BirthDateData = $birthDateData;
        }
        return $this;
    }
    /**
     * Get Closed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getClosed()
    {
        return isset($this->Closed) ? $this->Closed : null;
    }
    /**
     * Set Closed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $closed
     * @return \StructType\CustomerSearchDataType
     */
    public function setClosed($closed = null)
    {
        if (is_null($closed) || (is_array($closed) && empty($closed))) {
            unset($this->Closed);
        } else {
            $this->Closed = $closed;
        }
        return $this;
    }
    /**
     * Get CreationStoreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationStoreId()
    {
        return isset($this->CreationStoreId) ? $this->CreationStoreId : null;
    }
    /**
     * Set CreationStoreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationStoreId
     * @return \StructType\CustomerSearchDataType
     */
    public function setCreationStoreId($creationStoreId = null)
    {
        // validation for constraint: string
        if (!is_null($creationStoreId) && !is_string($creationStoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationStoreId)), __LINE__);
        }
        if (is_null($creationStoreId) || (is_array($creationStoreId) && empty($creationStoreId))) {
            unset($this->CreationStoreId);
        } else {
            $this->CreationStoreId = $creationStoreId;
        }
        return $this;
    }
    /**
     * Get CustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerId()
    {
        return isset($this->CustomerId) ? $this->CustomerId : null;
    }
    /**
     * Set CustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerId
     * @return \StructType\CustomerSearchDataType
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerId)), __LINE__);
        }
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->CustomerId);
        } else {
            $this->CustomerId = $customerId;
        }
        return $this;
    }
    /**
     * Get CustomerReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerReference()
    {
        return isset($this->CustomerReference) ? $this->CustomerReference : null;
    }
    /**
     * Set CustomerReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerReference
     * @return \StructType\CustomerSearchDataType
     */
    public function setCustomerReference($customerReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference) && !is_string($customerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerReference)), __LINE__);
        }
        if (is_null($customerReference) || (is_array($customerReference) && empty($customerReference))) {
            unset($this->CustomerReference);
        } else {
            $this->CustomerReference = $customerReference;
        }
        return $this;
    }
    /**
     * Get FiscalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFiscalId()
    {
        return isset($this->FiscalId) ? $this->FiscalId : null;
    }
    /**
     * Set FiscalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fiscalId
     * @return \StructType\CustomerSearchDataType
     */
    public function setFiscalId($fiscalId = null)
    {
        // validation for constraint: string
        if (!is_null($fiscalId) && !is_string($fiscalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fiscalId)), __LINE__);
        }
        if (is_null($fiscalId) || (is_array($fiscalId) && empty($fiscalId))) {
            unset($this->FiscalId);
        } else {
            $this->FiscalId = $fiscalId;
        }
        return $this;
    }
    /**
     * Get IsCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCustomer()
    {
        return isset($this->IsCustomer) ? $this->IsCustomer : null;
    }
    /**
     * Set IsCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCustomer
     * @return \StructType\CustomerSearchDataType
     */
    public function setIsCustomer($isCustomer = null)
    {
        if (is_null($isCustomer) || (is_array($isCustomer) && empty($isCustomer))) {
            unset($this->IsCustomer);
        } else {
            $this->IsCustomer = $isCustomer;
        }
        return $this;
    }
    /**
     * Get IsProspect value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsProspect()
    {
        return isset($this->IsProspect) ? $this->IsProspect : null;
    }
    /**
     * Set IsProspect value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isProspect
     * @return \StructType\CustomerSearchDataType
     */
    public function setIsProspect($isProspect = null)
    {
        if (is_null($isProspect) || (is_array($isProspect) && empty($isProspect))) {
            unset($this->IsProspect);
        } else {
            $this->IsProspect = $isProspect;
        }
        return $this;
    }
    /**
     * Get MaxNumberOfCustomers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxNumberOfCustomers()
    {
        return isset($this->MaxNumberOfCustomers) ? $this->MaxNumberOfCustomers : null;
    }
    /**
     * Set MaxNumberOfCustomers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxNumberOfCustomers
     * @return \StructType\CustomerSearchDataType
     */
    public function setMaxNumberOfCustomers($maxNumberOfCustomers = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfCustomers) && !is_numeric($maxNumberOfCustomers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxNumberOfCustomers)), __LINE__);
        }
        if (is_null($maxNumberOfCustomers) || (is_array($maxNumberOfCustomers) && empty($maxNumberOfCustomers))) {
            unset($this->MaxNumberOfCustomers);
        } else {
            $this->MaxNumberOfCustomers = $maxNumberOfCustomers;
        }
        return $this;
    }
    /**
     * Get NationalityData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NationalityDataType|null
     */
    public function getNationalityData()
    {
        return isset($this->NationalityData) ? $this->NationalityData : null;
    }
    /**
     * Set NationalityData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\NationalityDataType $nationalityData
     * @return \StructType\CustomerSearchDataType
     */
    public function setNationalityData(\StructType\NationalityDataType $nationalityData = null)
    {
        if (is_null($nationalityData) || (is_array($nationalityData) && empty($nationalityData))) {
            unset($this->NationalityData);
        } else {
            $this->NationalityData = $nationalityData;
        }
        return $this;
    }
    /**
     * Get PassportNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassportNumber()
    {
        return isset($this->PassportNumber) ? $this->PassportNumber : null;
    }
    /**
     * Set PassportNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passportNumber
     * @return \StructType\CustomerSearchDataType
     */
    public function setPassportNumber($passportNumber = null)
    {
        // validation for constraint: string
        if (!is_null($passportNumber) && !is_string($passportNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passportNumber)), __LINE__);
        }
        if (is_null($passportNumber) || (is_array($passportNumber) && empty($passportNumber))) {
            unset($this->PassportNumber);
        } else {
            $this->PassportNumber = $passportNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerSearchDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
