<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerData StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerData
 * @subpackage Structs
 */
class CustomerData extends CustomerDataBase
{
    /**
     * The ActivityCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of the customer's sales division. - Related to column CBR [TIERS.T_APE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityCode;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - documentation: Customer barcode. - Related to column CBR [TIERS.T_EAN].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BirthDateData
     * Meta informations extracted from the WSDL
     * - documentation: [Optional].
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BirthDateDataType
     */
    public $BirthDateData;
    /**
     * The CompanyIdNumber
     * Meta informations extracted from the WSDL
     * - documentation: Customer's Company Registration Number. - Related to column CBR [TIERS.T_SIRET].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyIdNumber;
    /**
     * The CompanyTitleId
     * Meta informations extracted from the WSDL
     * - documentation: Customer's title or position in the company. - Related to column CBR [TIERS.T_FORMEJURIDIQUE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyTitleId;
    /**
     * The CurrencyId
     * Meta informations extracted from the WSDL
     * - documentation: Customer currency ID. - Related to column CBR [TIERS.T_DEVISE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyId;
    /**
     * The FiscalId
     * Meta informations extracted from the WSDL
     * - documentation: Customer TIN or VAT identification number. - Related to column CBR [TIERS.T_NIF].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FiscalId;
    /**
     * The ItalianFiscalId
     * Meta informations extracted from the WSDL
     * - documentation: Customer fiscal identifier for Italian tax administration. - Related to column CBR [TIERSCOMPL.YTC_CODEFISCIT].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItalianFiscalId;
    /**
     * The LanguageId
     * Meta informations extracted from the WSDL
     * - documentation: Customer's language ID. - Related to column CBR [TIERS.T_LANGUE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LanguageId;
    /**
     * The LongDescription
     * Meta informations extracted from the WSDL
     * - documentation: Customer's nickname/short name. - Related to column CBR [TIERS.T_COMMENTAIRE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LongDescription;
    /**
     * The NationalityId
     * Meta informations extracted from the WSDL
     * - documentation: Customer's nationality ID. - Related to column CBR [TIERS.T_NATIONALITE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NationalityId;
    /**
     * The OptinAlternativeEmail
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/11 - V1105] [Optional] - Info E-mail 2 - Related to column CBR [TIERSCOMPL.YTC_INFOEMAIL2].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptinAlternativeEmail;
    /**
     * The OptinEmail
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/11 - V1105] [Optional] - Info E-mail - Related to column CBR [TIERSCOMPL.YTC_INFOEMAIL1].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptinEmail;
    /**
     * The OptinHomePhone
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2015/05 - V1201] [Optional] - Info Phone Home - Related to column CBR [TIERSCOMPL.YTC_INFOTEL1].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptinHomePhone;
    /**
     * The OptinMobile
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/11 - V1105] [Optional] - Info Phone - Related to column CBR [TIERSCOMPL.YTC_INFOTEL3].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptinMobile;
    /**
     * The OptinOfficePhone
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/11 - V1105] [Optional] - Info Phone Office - Related to column CBR [TIERSCOMPL.YTC_INFOTEL2].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptinOfficePhone;
    /**
     * The OptinPostal
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/11 - V1105] [Optional] - Info Address - Related to column CBR [TIERSCOMPL.YTC_INFOADRESSE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptinPostal;
    /**
     * The PassportNumber
     * Meta informations extracted from the WSDL
     * - documentation: Customer's passport - Related to column CBR [TIERS.T_PASSEPORT].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassportNumber;
    /**
     * The Sex
     * Meta informations extracted from the WSDL
     * - documentation: Customer's gender. - Related to column CBR [TIERS.T_SEXE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sex;
    /**
     * The ShortName
     * Meta informations extracted from the WSDL
     * - documentation: Customer's nickname/short name. - Related to column CBR [TIERS.T_ABREGE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShortName;
    /**
     * The UserFields
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2014/10 - V1105] [Optional] - User fields.
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfUserField
     */
    public $UserFields;
    /**
     * The VATSystem
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2014/08 - V1105] [Beta] [Optional] - VAT system - Related to column CBR [TIERS.T_REGIMETVA].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VATSystem;
    /**
     * The ValidAlternativeEmail
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/11 - V1105] [Optional] - E-mail 2: valid - Related to column CBR [TIERSCOMPL.YTC_EMAIL2VALIDE].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ValidAlternativeEmail;
    /**
     * The ValidEmail
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/11 - V1105] [Optional] - E-mail: valid - Related to column CBR [TIERSCOMPL.YTC_EMAIL1VALIDE].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ValidEmail;
    /**
     * The ValidHomePhone
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/11 - V1201] [Optional] - Phone Home: valid - Related to column CBR [TIERSCOMPL.YTC_TEL1VALIDE].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ValidHomePhone;
    /**
     * The ValidMobile
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/11 - V1105] [Optional] - Mobile phone: valid - Related to column CBR [TIERSCOMPL.YTC_TEL3VALIDE].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ValidMobile;
    /**
     * The ValidOfficePhone
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/11 - V1105] [Optional] - Pone Office: valid - Related to column CBR [TIERSCOMPL.YTC_TEL2VALIDE].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ValidOfficePhone;
    /**
     * Constructor method for CustomerData
     * @uses CustomerData::setActivityCode()
     * @uses CustomerData::setBarcode()
     * @uses CustomerData::setBirthDateData()
     * @uses CustomerData::setCompanyIdNumber()
     * @uses CustomerData::setCompanyTitleId()
     * @uses CustomerData::setCurrencyId()
     * @uses CustomerData::setFiscalId()
     * @uses CustomerData::setItalianFiscalId()
     * @uses CustomerData::setLanguageId()
     * @uses CustomerData::setLongDescription()
     * @uses CustomerData::setNationalityId()
     * @uses CustomerData::setOptinAlternativeEmail()
     * @uses CustomerData::setOptinEmail()
     * @uses CustomerData::setOptinHomePhone()
     * @uses CustomerData::setOptinMobile()
     * @uses CustomerData::setOptinOfficePhone()
     * @uses CustomerData::setOptinPostal()
     * @uses CustomerData::setPassportNumber()
     * @uses CustomerData::setSex()
     * @uses CustomerData::setShortName()
     * @uses CustomerData::setUserFields()
     * @uses CustomerData::setVATSystem()
     * @uses CustomerData::setValidAlternativeEmail()
     * @uses CustomerData::setValidEmail()
     * @uses CustomerData::setValidHomePhone()
     * @uses CustomerData::setValidMobile()
     * @uses CustomerData::setValidOfficePhone()
     * @param string $activityCode
     * @param string $barcode
     * @param \StructType\BirthDateDataType $birthDateData
     * @param string $companyIdNumber
     * @param string $companyTitleId
     * @param string $currencyId
     * @param string $fiscalId
     * @param string $italianFiscalId
     * @param string $languageId
     * @param string $longDescription
     * @param string $nationalityId
     * @param string $optinAlternativeEmail
     * @param string $optinEmail
     * @param string $optinHomePhone
     * @param string $optinMobile
     * @param string $optinOfficePhone
     * @param string $optinPostal
     * @param string $passportNumber
     * @param string $sex
     * @param string $shortName
     * @param \ArrayType\ArrayOfUserField $userFields
     * @param string $vATSystem
     * @param bool $validAlternativeEmail
     * @param bool $validEmail
     * @param bool $validHomePhone
     * @param bool $validMobile
     * @param bool $validOfficePhone
     */
    public function __construct($activityCode = null, $barcode = null, \StructType\BirthDateDataType $birthDateData = null, $companyIdNumber = null, $companyTitleId = null, $currencyId = null, $fiscalId = null, $italianFiscalId = null, $languageId = null, $longDescription = null, $nationalityId = null, $optinAlternativeEmail = null, $optinEmail = null, $optinHomePhone = null, $optinMobile = null, $optinOfficePhone = null, $optinPostal = null, $passportNumber = null, $sex = null, $shortName = null, \ArrayType\ArrayOfUserField $userFields = null, $vATSystem = null, $validAlternativeEmail = null, $validEmail = null, $validHomePhone = null, $validMobile = null, $validOfficePhone = null)
    {
        $this
            ->setActivityCode($activityCode)
            ->setBarcode($barcode)
            ->setBirthDateData($birthDateData)
            ->setCompanyIdNumber($companyIdNumber)
            ->setCompanyTitleId($companyTitleId)
            ->setCurrencyId($currencyId)
            ->setFiscalId($fiscalId)
            ->setItalianFiscalId($italianFiscalId)
            ->setLanguageId($languageId)
            ->setLongDescription($longDescription)
            ->setNationalityId($nationalityId)
            ->setOptinAlternativeEmail($optinAlternativeEmail)
            ->setOptinEmail($optinEmail)
            ->setOptinHomePhone($optinHomePhone)
            ->setOptinMobile($optinMobile)
            ->setOptinOfficePhone($optinOfficePhone)
            ->setOptinPostal($optinPostal)
            ->setPassportNumber($passportNumber)
            ->setSex($sex)
            ->setShortName($shortName)
            ->setUserFields($userFields)
            ->setVATSystem($vATSystem)
            ->setValidAlternativeEmail($validAlternativeEmail)
            ->setValidEmail($validEmail)
            ->setValidHomePhone($validHomePhone)
            ->setValidMobile($validMobile)
            ->setValidOfficePhone($validOfficePhone);
    }
    /**
     * Get ActivityCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityCode()
    {
        return isset($this->ActivityCode) ? $this->ActivityCode : null;
    }
    /**
     * Set ActivityCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityCode
     * @return \StructType\CustomerData
     */
    public function setActivityCode($activityCode = null)
    {
        // validation for constraint: string
        if (!is_null($activityCode) && !is_string($activityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityCode)), __LINE__);
        }
        if (is_null($activityCode) || (is_array($activityCode) && empty($activityCode))) {
            unset($this->ActivityCode);
        } else {
            $this->ActivityCode = $activityCode;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \StructType\CustomerData
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BirthDateData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BirthDateDataType|null
     */
    public function getBirthDateData()
    {
        return isset($this->BirthDateData) ? $this->BirthDateData : null;
    }
    /**
     * Set BirthDateData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BirthDateDataType $birthDateData
     * @return \StructType\CustomerData
     */
    public function setBirthDateData(\StructType\BirthDateDataType $birthDateData = null)
    {
        if (is_null($birthDateData) || (is_array($birthDateData) && empty($birthDateData))) {
            unset($this->BirthDateData);
        } else {
            $this->BirthDateData = $birthDateData;
        }
        return $this;
    }
    /**
     * Get CompanyIdNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyIdNumber()
    {
        return isset($this->CompanyIdNumber) ? $this->CompanyIdNumber : null;
    }
    /**
     * Set CompanyIdNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyIdNumber
     * @return \StructType\CustomerData
     */
    public function setCompanyIdNumber($companyIdNumber = null)
    {
        // validation for constraint: string
        if (!is_null($companyIdNumber) && !is_string($companyIdNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyIdNumber)), __LINE__);
        }
        if (is_null($companyIdNumber) || (is_array($companyIdNumber) && empty($companyIdNumber))) {
            unset($this->CompanyIdNumber);
        } else {
            $this->CompanyIdNumber = $companyIdNumber;
        }
        return $this;
    }
    /**
     * Get CompanyTitleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyTitleId()
    {
        return isset($this->CompanyTitleId) ? $this->CompanyTitleId : null;
    }
    /**
     * Set CompanyTitleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyTitleId
     * @return \StructType\CustomerData
     */
    public function setCompanyTitleId($companyTitleId = null)
    {
        // validation for constraint: string
        if (!is_null($companyTitleId) && !is_string($companyTitleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyTitleId)), __LINE__);
        }
        if (is_null($companyTitleId) || (is_array($companyTitleId) && empty($companyTitleId))) {
            unset($this->CompanyTitleId);
        } else {
            $this->CompanyTitleId = $companyTitleId;
        }
        return $this;
    }
    /**
     * Get CurrencyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyId()
    {
        return isset($this->CurrencyId) ? $this->CurrencyId : null;
    }
    /**
     * Set CurrencyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyId
     * @return \StructType\CustomerData
     */
    public function setCurrencyId($currencyId = null)
    {
        // validation for constraint: string
        if (!is_null($currencyId) && !is_string($currencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyId)), __LINE__);
        }
        if (is_null($currencyId) || (is_array($currencyId) && empty($currencyId))) {
            unset($this->CurrencyId);
        } else {
            $this->CurrencyId = $currencyId;
        }
        return $this;
    }
    /**
     * Get FiscalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFiscalId()
    {
        return isset($this->FiscalId) ? $this->FiscalId : null;
    }
    /**
     * Set FiscalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fiscalId
     * @return \StructType\CustomerData
     */
    public function setFiscalId($fiscalId = null)
    {
        // validation for constraint: string
        if (!is_null($fiscalId) && !is_string($fiscalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fiscalId)), __LINE__);
        }
        if (is_null($fiscalId) || (is_array($fiscalId) && empty($fiscalId))) {
            unset($this->FiscalId);
        } else {
            $this->FiscalId = $fiscalId;
        }
        return $this;
    }
    /**
     * Get ItalianFiscalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItalianFiscalId()
    {
        return isset($this->ItalianFiscalId) ? $this->ItalianFiscalId : null;
    }
    /**
     * Set ItalianFiscalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $italianFiscalId
     * @return \StructType\CustomerData
     */
    public function setItalianFiscalId($italianFiscalId = null)
    {
        // validation for constraint: string
        if (!is_null($italianFiscalId) && !is_string($italianFiscalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($italianFiscalId)), __LINE__);
        }
        if (is_null($italianFiscalId) || (is_array($italianFiscalId) && empty($italianFiscalId))) {
            unset($this->ItalianFiscalId);
        } else {
            $this->ItalianFiscalId = $italianFiscalId;
        }
        return $this;
    }
    /**
     * Get LanguageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLanguageId()
    {
        return isset($this->LanguageId) ? $this->LanguageId : null;
    }
    /**
     * Set LanguageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $languageId
     * @return \StructType\CustomerData
     */
    public function setLanguageId($languageId = null)
    {
        // validation for constraint: string
        if (!is_null($languageId) && !is_string($languageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageId)), __LINE__);
        }
        if (is_null($languageId) || (is_array($languageId) && empty($languageId))) {
            unset($this->LanguageId);
        } else {
            $this->LanguageId = $languageId;
        }
        return $this;
    }
    /**
     * Get LongDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLongDescription()
    {
        return isset($this->LongDescription) ? $this->LongDescription : null;
    }
    /**
     * Set LongDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $longDescription
     * @return \StructType\CustomerData
     */
    public function setLongDescription($longDescription = null)
    {
        // validation for constraint: string
        if (!is_null($longDescription) && !is_string($longDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($longDescription)), __LINE__);
        }
        if (is_null($longDescription) || (is_array($longDescription) && empty($longDescription))) {
            unset($this->LongDescription);
        } else {
            $this->LongDescription = $longDescription;
        }
        return $this;
    }
    /**
     * Get NationalityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNationalityId()
    {
        return isset($this->NationalityId) ? $this->NationalityId : null;
    }
    /**
     * Set NationalityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nationalityId
     * @return \StructType\CustomerData
     */
    public function setNationalityId($nationalityId = null)
    {
        // validation for constraint: string
        if (!is_null($nationalityId) && !is_string($nationalityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalityId)), __LINE__);
        }
        if (is_null($nationalityId) || (is_array($nationalityId) && empty($nationalityId))) {
            unset($this->NationalityId);
        } else {
            $this->NationalityId = $nationalityId;
        }
        return $this;
    }
    /**
     * Get OptinAlternativeEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptinAlternativeEmail()
    {
        return isset($this->OptinAlternativeEmail) ? $this->OptinAlternativeEmail : null;
    }
    /**
     * Set OptinAlternativeEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CustomerInformationType::valueIsValid()
     * @uses \EnumType\CustomerInformationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optinAlternativeEmail
     * @return \StructType\CustomerData
     */
    public function setOptinAlternativeEmail($optinAlternativeEmail = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerInformationType::valueIsValid($optinAlternativeEmail)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optinAlternativeEmail, implode(', ', \EnumType\CustomerInformationType::getValidValues())), __LINE__);
        }
        if (is_null($optinAlternativeEmail) || (is_array($optinAlternativeEmail) && empty($optinAlternativeEmail))) {
            unset($this->OptinAlternativeEmail);
        } else {
            $this->OptinAlternativeEmail = $optinAlternativeEmail;
        }
        return $this;
    }
    /**
     * Get OptinEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptinEmail()
    {
        return isset($this->OptinEmail) ? $this->OptinEmail : null;
    }
    /**
     * Set OptinEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CustomerInformationType::valueIsValid()
     * @uses \EnumType\CustomerInformationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optinEmail
     * @return \StructType\CustomerData
     */
    public function setOptinEmail($optinEmail = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerInformationType::valueIsValid($optinEmail)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optinEmail, implode(', ', \EnumType\CustomerInformationType::getValidValues())), __LINE__);
        }
        if (is_null($optinEmail) || (is_array($optinEmail) && empty($optinEmail))) {
            unset($this->OptinEmail);
        } else {
            $this->OptinEmail = $optinEmail;
        }
        return $this;
    }
    /**
     * Get OptinHomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptinHomePhone()
    {
        return isset($this->OptinHomePhone) ? $this->OptinHomePhone : null;
    }
    /**
     * Set OptinHomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CustomerInformationType::valueIsValid()
     * @uses \EnumType\CustomerInformationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optinHomePhone
     * @return \StructType\CustomerData
     */
    public function setOptinHomePhone($optinHomePhone = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerInformationType::valueIsValid($optinHomePhone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optinHomePhone, implode(', ', \EnumType\CustomerInformationType::getValidValues())), __LINE__);
        }
        if (is_null($optinHomePhone) || (is_array($optinHomePhone) && empty($optinHomePhone))) {
            unset($this->OptinHomePhone);
        } else {
            $this->OptinHomePhone = $optinHomePhone;
        }
        return $this;
    }
    /**
     * Get OptinMobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptinMobile()
    {
        return isset($this->OptinMobile) ? $this->OptinMobile : null;
    }
    /**
     * Set OptinMobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CustomerInformationType::valueIsValid()
     * @uses \EnumType\CustomerInformationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optinMobile
     * @return \StructType\CustomerData
     */
    public function setOptinMobile($optinMobile = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerInformationType::valueIsValid($optinMobile)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optinMobile, implode(', ', \EnumType\CustomerInformationType::getValidValues())), __LINE__);
        }
        if (is_null($optinMobile) || (is_array($optinMobile) && empty($optinMobile))) {
            unset($this->OptinMobile);
        } else {
            $this->OptinMobile = $optinMobile;
        }
        return $this;
    }
    /**
     * Get OptinOfficePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptinOfficePhone()
    {
        return isset($this->OptinOfficePhone) ? $this->OptinOfficePhone : null;
    }
    /**
     * Set OptinOfficePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CustomerInformationType::valueIsValid()
     * @uses \EnumType\CustomerInformationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optinOfficePhone
     * @return \StructType\CustomerData
     */
    public function setOptinOfficePhone($optinOfficePhone = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerInformationType::valueIsValid($optinOfficePhone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optinOfficePhone, implode(', ', \EnumType\CustomerInformationType::getValidValues())), __LINE__);
        }
        if (is_null($optinOfficePhone) || (is_array($optinOfficePhone) && empty($optinOfficePhone))) {
            unset($this->OptinOfficePhone);
        } else {
            $this->OptinOfficePhone = $optinOfficePhone;
        }
        return $this;
    }
    /**
     * Get OptinPostal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptinPostal()
    {
        return isset($this->OptinPostal) ? $this->OptinPostal : null;
    }
    /**
     * Set OptinPostal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\CustomerInformationType::valueIsValid()
     * @uses \EnumType\CustomerInformationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $optinPostal
     * @return \StructType\CustomerData
     */
    public function setOptinPostal($optinPostal = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerInformationType::valueIsValid($optinPostal)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $optinPostal, implode(', ', \EnumType\CustomerInformationType::getValidValues())), __LINE__);
        }
        if (is_null($optinPostal) || (is_array($optinPostal) && empty($optinPostal))) {
            unset($this->OptinPostal);
        } else {
            $this->OptinPostal = $optinPostal;
        }
        return $this;
    }
    /**
     * Get PassportNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassportNumber()
    {
        return isset($this->PassportNumber) ? $this->PassportNumber : null;
    }
    /**
     * Set PassportNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passportNumber
     * @return \StructType\CustomerData
     */
    public function setPassportNumber($passportNumber = null)
    {
        // validation for constraint: string
        if (!is_null($passportNumber) && !is_string($passportNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passportNumber)), __LINE__);
        }
        if (is_null($passportNumber) || (is_array($passportNumber) && empty($passportNumber))) {
            unset($this->PassportNumber);
        } else {
            $this->PassportNumber = $passportNumber;
        }
        return $this;
    }
    /**
     * Get Sex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSex()
    {
        return isset($this->Sex) ? $this->Sex : null;
    }
    /**
     * Set Sex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sex
     * @return \StructType\CustomerData
     */
    public function setSex($sex = null)
    {
        // validation for constraint: string
        if (!is_null($sex) && !is_string($sex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sex)), __LINE__);
        }
        if (is_null($sex) || (is_array($sex) && empty($sex))) {
            unset($this->Sex);
        } else {
            $this->Sex = $sex;
        }
        return $this;
    }
    /**
     * Get ShortName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShortName()
    {
        return isset($this->ShortName) ? $this->ShortName : null;
    }
    /**
     * Set ShortName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shortName
     * @return \StructType\CustomerData
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortName)), __LINE__);
        }
        if (is_null($shortName) || (is_array($shortName) && empty($shortName))) {
            unset($this->ShortName);
        } else {
            $this->ShortName = $shortName;
        }
        return $this;
    }
    /**
     * Get UserFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfUserField|null
     */
    public function getUserFields()
    {
        return isset($this->UserFields) ? $this->UserFields : null;
    }
    /**
     * Set UserFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfUserField $userFields
     * @return \StructType\CustomerData
     */
    public function setUserFields(\ArrayType\ArrayOfUserField $userFields = null)
    {
        if (is_null($userFields) || (is_array($userFields) && empty($userFields))) {
            unset($this->UserFields);
        } else {
            $this->UserFields = $userFields;
        }
        return $this;
    }
    /**
     * Get VATSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVATSystem()
    {
        return isset($this->VATSystem) ? $this->VATSystem : null;
    }
    /**
     * Set VATSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vATSystem
     * @return \StructType\CustomerData
     */
    public function setVATSystem($vATSystem = null)
    {
        // validation for constraint: string
        if (!is_null($vATSystem) && !is_string($vATSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vATSystem)), __LINE__);
        }
        if (is_null($vATSystem) || (is_array($vATSystem) && empty($vATSystem))) {
            unset($this->VATSystem);
        } else {
            $this->VATSystem = $vATSystem;
        }
        return $this;
    }
    /**
     * Get ValidAlternativeEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getValidAlternativeEmail()
    {
        return isset($this->ValidAlternativeEmail) ? $this->ValidAlternativeEmail : null;
    }
    /**
     * Set ValidAlternativeEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $validAlternativeEmail
     * @return \StructType\CustomerData
     */
    public function setValidAlternativeEmail($validAlternativeEmail = null)
    {
        if (is_null($validAlternativeEmail) || (is_array($validAlternativeEmail) && empty($validAlternativeEmail))) {
            unset($this->ValidAlternativeEmail);
        } else {
            $this->ValidAlternativeEmail = $validAlternativeEmail;
        }
        return $this;
    }
    /**
     * Get ValidEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getValidEmail()
    {
        return isset($this->ValidEmail) ? $this->ValidEmail : null;
    }
    /**
     * Set ValidEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $validEmail
     * @return \StructType\CustomerData
     */
    public function setValidEmail($validEmail = null)
    {
        if (is_null($validEmail) || (is_array($validEmail) && empty($validEmail))) {
            unset($this->ValidEmail);
        } else {
            $this->ValidEmail = $validEmail;
        }
        return $this;
    }
    /**
     * Get ValidHomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getValidHomePhone()
    {
        return isset($this->ValidHomePhone) ? $this->ValidHomePhone : null;
    }
    /**
     * Set ValidHomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $validHomePhone
     * @return \StructType\CustomerData
     */
    public function setValidHomePhone($validHomePhone = null)
    {
        if (is_null($validHomePhone) || (is_array($validHomePhone) && empty($validHomePhone))) {
            unset($this->ValidHomePhone);
        } else {
            $this->ValidHomePhone = $validHomePhone;
        }
        return $this;
    }
    /**
     * Get ValidMobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getValidMobile()
    {
        return isset($this->ValidMobile) ? $this->ValidMobile : null;
    }
    /**
     * Set ValidMobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $validMobile
     * @return \StructType\CustomerData
     */
    public function setValidMobile($validMobile = null)
    {
        if (is_null($validMobile) || (is_array($validMobile) && empty($validMobile))) {
            unset($this->ValidMobile);
        } else {
            $this->ValidMobile = $validMobile;
        }
        return $this;
    }
    /**
     * Get ValidOfficePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getValidOfficePhone()
    {
        return isset($this->ValidOfficePhone) ? $this->ValidOfficePhone : null;
    }
    /**
     * Set ValidOfficePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $validOfficePhone
     * @return \StructType\CustomerData
     */
    public function setValidOfficePhone($validOfficePhone = null)
    {
        if (is_null($validOfficePhone) || (is_array($validOfficePhone) && empty($validOfficePhone))) {
            unset($this->ValidOfficePhone);
        } else {
            $this->ValidOfficePhone = $validOfficePhone;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
