<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCustomerIdByReference
     * Meta informations extracted from the WSDL
     * - documentation: Returns the identifier of the customer matching a given customer reference. | Reference enabling the identification of the customer. | Returns the identifier of the customer found.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerIdByReference $parameters
     * @return \StructType\GetCustomerIdByReferenceResponse|bool
     */
    public function GetCustomerIdByReference(\StructType\GetCustomerIdByReference $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerIdByReference($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomerDetail
     * Meta informations extracted from the WSDL
     * - documentation: Returns information that can be viewed from the customer record. | Customer identifier.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomerDetail $parameters
     * @return \StructType\GetCustomerDetailResponse|bool
     */
    public function GetCustomerDetail(\StructType\GetCustomerDetail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomerDetail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCustomerDetailResponse|\StructType\GetCustomerIdByReferenceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
