<?php

namespace EnumType;

/**
 * This class stands for CustomerInformationType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Customer information
 * - nillable: true
 * - type: tns:CustomerInformationType
 * @subpackage Enumerations
 */
class CustomerInformationType
{
    /**
     * Constant for value 'AskCustomer'
     * @return string 'AskCustomer'
     */
    const VALUE_ASK_CUSTOMER = 'AskCustomer';
    /**
     * Constant for value 'BrandOnly'
     * @return string 'BrandOnly'
     */
    const VALUE_BRAND_ONLY = 'BrandOnly';
    /**
     * Constant for value 'ForPartners'
     * @return string 'ForPartners'
     */
    const VALUE_FOR_PARTNERS = 'ForPartners';
    /**
     * Constant for value 'DoNotUse'
     * @return string 'DoNotUse'
     */
    const VALUE_DO_NOT_USE = 'DoNotUse';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ASK_CUSTOMER
     * @uses self::VALUE_BRAND_ONLY
     * @uses self::VALUE_FOR_PARTNERS
     * @uses self::VALUE_DO_NOT_USE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ASK_CUSTOMER,
            self::VALUE_BRAND_ONLY,
            self::VALUE_FOR_PARTNERS,
            self::VALUE_DO_NOT_USE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
