<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUserDefinedValue ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfUserDefinedValue
 * @subpackage Arrays
 */
class ArrayOfUserDefinedValue extends AbstractStructArrayBase
{
    /**
     * The UserDefinedValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UserDefinedValue[]
     */
    public $UserDefinedValue;
    /**
     * Constructor method for ArrayOfUserDefinedValue
     * @uses ArrayOfUserDefinedValue::setUserDefinedValue()
     * @param \StructType\UserDefinedValue[] $userDefinedValue
     */
    public function __construct(array $userDefinedValue = array())
    {
        $this
            ->setUserDefinedValue($userDefinedValue);
    }
    /**
     * Get UserDefinedValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UserDefinedValue[]|null
     */
    public function getUserDefinedValue()
    {
        return isset($this->UserDefinedValue) ? $this->UserDefinedValue : null;
    }
    /**
     * Set UserDefinedValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UserDefinedValue[] $userDefinedValue
     * @return \ArrayType\ArrayOfUserDefinedValue
     */
    public function setUserDefinedValue(array $userDefinedValue = array())
    {
        foreach ($userDefinedValue as $arrayOfUserDefinedValueUserDefinedValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfUserDefinedValueUserDefinedValueItem instanceof \StructType\UserDefinedValue) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedValue property can only contain items of \StructType\UserDefinedValue, "%s" given', is_object($arrayOfUserDefinedValueUserDefinedValueItem) ? get_class($arrayOfUserDefinedValueUserDefinedValueItem) : gettype($arrayOfUserDefinedValueUserDefinedValueItem)), __LINE__);
            }
        }
        if (is_null($userDefinedValue) || (is_array($userDefinedValue) && empty($userDefinedValue))) {
            unset($this->UserDefinedValue);
        } else {
            $this->UserDefinedValue = $userDefinedValue;
        }
        return $this;
    }
    /**
     * Add item to UserDefinedValue value
     * @throws \InvalidArgumentException
     * @param \StructType\UserDefinedValue $item
     * @return \ArrayType\ArrayOfUserDefinedValue
     */
    public function addToUserDefinedValue(\StructType\UserDefinedValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserDefinedValue) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedValue property can only contain items of \StructType\UserDefinedValue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\UserDefinedValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\UserDefinedValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\UserDefinedValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\UserDefinedValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\UserDefinedValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UserDefinedValue
     */
    public function getAttributeName()
    {
        return 'UserDefinedValue';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfUserDefinedValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
