<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUserDefinedDate ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfUserDefinedDate
 * @subpackage Arrays
 */
class ArrayOfUserDefinedDate extends AbstractStructArrayBase
{
    /**
     * The UserDefinedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UserDefinedDate[]
     */
    public $UserDefinedDate;
    /**
     * Constructor method for ArrayOfUserDefinedDate
     * @uses ArrayOfUserDefinedDate::setUserDefinedDate()
     * @param \StructType\UserDefinedDate[] $userDefinedDate
     */
    public function __construct(array $userDefinedDate = array())
    {
        $this
            ->setUserDefinedDate($userDefinedDate);
    }
    /**
     * Get UserDefinedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UserDefinedDate[]|null
     */
    public function getUserDefinedDate()
    {
        return isset($this->UserDefinedDate) ? $this->UserDefinedDate : null;
    }
    /**
     * Set UserDefinedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UserDefinedDate[] $userDefinedDate
     * @return \ArrayType\ArrayOfUserDefinedDate
     */
    public function setUserDefinedDate(array $userDefinedDate = array())
    {
        foreach ($userDefinedDate as $arrayOfUserDefinedDateUserDefinedDateItem) {
            // validation for constraint: itemType
            if (!$arrayOfUserDefinedDateUserDefinedDateItem instanceof \StructType\UserDefinedDate) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedDate property can only contain items of \StructType\UserDefinedDate, "%s" given', is_object($arrayOfUserDefinedDateUserDefinedDateItem) ? get_class($arrayOfUserDefinedDateUserDefinedDateItem) : gettype($arrayOfUserDefinedDateUserDefinedDateItem)), __LINE__);
            }
        }
        if (is_null($userDefinedDate) || (is_array($userDefinedDate) && empty($userDefinedDate))) {
            unset($this->UserDefinedDate);
        } else {
            $this->UserDefinedDate = $userDefinedDate;
        }
        return $this;
    }
    /**
     * Add item to UserDefinedDate value
     * @throws \InvalidArgumentException
     * @param \StructType\UserDefinedDate $item
     * @return \ArrayType\ArrayOfUserDefinedDate
     */
    public function addToUserDefinedDate(\StructType\UserDefinedDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserDefinedDate) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedDate property can only contain items of \StructType\UserDefinedDate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedDate[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\UserDefinedDate|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\UserDefinedDate|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\UserDefinedDate|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\UserDefinedDate|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\UserDefinedDate|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UserDefinedDate
     */
    public function getAttributeName()
    {
        return 'UserDefinedDate';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfUserDefinedDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
