<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserDefinedValue StructType
 * Meta informations extracted from the WSDL
 * - documentation: User-defined numerical value
 * - nillable: true
 * - type: tns:UserDefinedValue
 * @subpackage Structs
 */
class UserDefinedValue extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Identifier.
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - documentation: Associated value.
     * - minOccurs: 0
     * @var float
     */
    public $Value;
    /**
     * Constructor method for UserDefinedValue
     * @uses UserDefinedValue::setId()
     * @uses UserDefinedValue::setValue()
     * @param string $id
     * @param float $value
     */
    public function __construct($id = null, $value = null)
    {
        $this
            ->setId($id)
            ->setValue($value);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @uses \EnumType\UserDefinedId::valueIsValid()
     * @uses \EnumType\UserDefinedId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $id
     * @return \StructType\UserDefinedValue
     */
    public function setId($id = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UserDefinedId::valueIsValid($id)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $id, implode(', ', \EnumType\UserDefinedId::getValidValues())), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param float $value
     * @return \StructType\UserDefinedValue
     */
    public function setValue($value = null)
    {
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserDefinedValue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
