<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserDefinedDate StructType
 * Meta informations extracted from the WSDL
 * - documentation: Data in user-defined date
 * - nillable: true
 * - type: tns:UserDefinedDate
 * @subpackage Structs
 */
class UserDefinedDate extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: User-defined date ID.
     * - minOccurs: 0
     * @var string
     */
    public $Id;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - documentation: user-defined date value. The date passed in must not specify time information.
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for UserDefinedDate
     * @uses UserDefinedDate::setId()
     * @uses UserDefinedDate::setValue()
     * @param string $id
     * @param string $value
     */
    public function __construct($id = null, $value = null)
    {
        $this
            ->setId($id)
            ->setValue($value);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @uses \EnumType\UserDefinedId::valueIsValid()
     * @uses \EnumType\UserDefinedId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $id
     * @return \StructType\UserDefinedDate
     */
    public function setId($id = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UserDefinedId::valueIsValid($id)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $id, implode(', ', \EnumType\UserDefinedId::getValidValues())), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\UserDefinedDate
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserDefinedDate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
