<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelloWorldResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: HelloWorld method to validate the access to Web Services from every very light HTTP client via Javascript for example
 * @subpackage Structs
 */
class HelloWorldResponse extends AbstractStructBase
{
    /**
     * The HelloWorldResult
     * Meta informations extracted from the WSDL
     * - documentation: Returns the text typed upon entry, concatenated with phrase 'Hello You'
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HelloWorldResult;
    /**
     * Constructor method for HelloWorldResponse
     * @uses HelloWorldResponse::setHelloWorldResult()
     * @param string $helloWorldResult
     */
    public function __construct($helloWorldResult = null)
    {
        $this
            ->setHelloWorldResult($helloWorldResult);
    }
    /**
     * Get HelloWorldResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHelloWorldResult()
    {
        return isset($this->HelloWorldResult) ? $this->HelloWorldResult : null;
    }
    /**
     * Set HelloWorldResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $helloWorldResult
     * @return \StructType\HelloWorldResponse
     */
    public function setHelloWorldResult($helloWorldResult = null)
    {
        // validation for constraint: string
        if (!is_null($helloWorldResult) && !is_string($helloWorldResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($helloWorldResult)), __LINE__);
        }
        if (is_null($helloWorldResult) || (is_array($helloWorldResult) && empty($helloWorldResult))) {
            unset($this->HelloWorldResult);
        } else {
            $this->HelloWorldResult = $helloWorldResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HelloWorldResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
