<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelloWorld StructType
 * Meta informations extracted from the WSDL
 * - documentation: HelloWorld method to validate the access to Web Services from every very light HTTP client via Javascript for example
 * @subpackage Structs
 */
class HelloWorld extends AbstractStructBase
{
    /**
     * The text
     * Meta informations extracted from the WSDL
     * - documentation: Text to pass to test consumption.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $text;
    /**
     * The clientContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetailContext
     */
    public $clientContext;
    /**
     * Constructor method for HelloWorld
     * @uses HelloWorld::setText()
     * @uses HelloWorld::setClientContext()
     * @param string $text
     * @param \StructType\RetailContext $clientContext
     */
    public function __construct($text = null, \StructType\RetailContext $clientContext = null)
    {
        $this
            ->setText($text)
            ->setClientContext($clientContext);
    }
    /**
     * Get text value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getText()
    {
        return isset($this->text) ? $this->text : null;
    }
    /**
     * Set text value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $text
     * @return \StructType\HelloWorld
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        if (is_null($text) || (is_array($text) && empty($text))) {
            unset($this->text);
        } else {
            $this->text = $text;
        }
        return $this;
    }
    /**
     * Get clientContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetailContext|null
     */
    public function getClientContext()
    {
        return isset($this->clientContext) ? $this->clientContext : null;
    }
    /**
     * Set clientContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetailContext $clientContext
     * @return \StructType\HelloWorld
     */
    public function setClientContext(\StructType\RetailContext $clientContext = null)
    {
        if (is_null($clientContext) || (is_array($clientContext) && empty($clientContext))) {
            unset($this->clientContext);
        } else {
            $this->clientContext = $clientContext;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HelloWorld
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
