<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerDetail StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns information that can be viewed from the customer record.
 * @subpackage Structs
 */
class GetCustomerDetail extends AbstractStructBase
{
    /**
     * The customerId
     * Meta informations extracted from the WSDL
     * - documentation: Customer identifier.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $customerId;
    /**
     * The clientContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetailContext
     */
    public $clientContext;
    /**
     * Constructor method for GetCustomerDetail
     * @uses GetCustomerDetail::setCustomerId()
     * @uses GetCustomerDetail::setClientContext()
     * @param string $customerId
     * @param \StructType\RetailContext $clientContext
     */
    public function __construct($customerId = null, \StructType\RetailContext $clientContext = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setClientContext($clientContext);
    }
    /**
     * Get customerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerId()
    {
        return isset($this->customerId) ? $this->customerId : null;
    }
    /**
     * Set customerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerId
     * @return \StructType\GetCustomerDetail
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerId)), __LINE__);
        }
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->customerId);
        } else {
            $this->customerId = $customerId;
        }
        return $this;
    }
    /**
     * Get clientContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetailContext|null
     */
    public function getClientContext()
    {
        return isset($this->clientContext) ? $this->clientContext : null;
    }
    /**
     * Set clientContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetailContext $clientContext
     * @return \StructType\GetCustomerDetail
     */
    public function setClientContext(\StructType\RetailContext $clientContext = null)
    {
        if (is_null($clientContext) || (is_array($clientContext) && empty($clientContext))) {
            unset($this->clientContext);
        } else {
            $this->clientContext = $clientContext;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
