<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Customer's E-mails.
 * - nillable: true
 * - type: tns:EmailDataType
 * @subpackage Structs
 */
class EmailDataType extends AbstractStructBase
{
    /**
     * The AlternativeEmail
     * Meta informations extracted from the WSDL
     * - documentation: Customer's alternate E-mail. - Related to column CBR [TIERS.T_EMAIL2].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternativeEmail;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - documentation: Customer's E-mail. - Related to column CBR [TIERS.T_EMAIL].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The EmailingAccepted
     * Meta informations extracted from the WSDL
     * - documentation: [Optional] - Property specifying whether the customer accepts e-mailing. - Related to column CBR [TIERS.T_EMAILING].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EmailingAccepted;
    /**
     * The SendReceiptByMail
     * Meta informations extracted from the WSDL
     * - documentation: [Optional] - Customer's agreement for e-mailing sales receipts - Related to column CBR [TIERSCOMPL.YTC_ENVTICKEMAIL].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendReceiptByMail;
    /**
     * Constructor method for EmailDataType
     * @uses EmailDataType::setAlternativeEmail()
     * @uses EmailDataType::setEmail()
     * @uses EmailDataType::setEmailingAccepted()
     * @uses EmailDataType::setSendReceiptByMail()
     * @param string $alternativeEmail
     * @param string $email
     * @param bool $emailingAccepted
     * @param bool $sendReceiptByMail
     */
    public function __construct($alternativeEmail = null, $email = null, $emailingAccepted = null, $sendReceiptByMail = null)
    {
        $this
            ->setAlternativeEmail($alternativeEmail)
            ->setEmail($email)
            ->setEmailingAccepted($emailingAccepted)
            ->setSendReceiptByMail($sendReceiptByMail);
    }
    /**
     * Get AlternativeEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternativeEmail()
    {
        return isset($this->AlternativeEmail) ? $this->AlternativeEmail : null;
    }
    /**
     * Set AlternativeEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternativeEmail
     * @return \StructType\EmailDataType
     */
    public function setAlternativeEmail($alternativeEmail = null)
    {
        // validation for constraint: string
        if (!is_null($alternativeEmail) && !is_string($alternativeEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternativeEmail)), __LINE__);
        }
        if (is_null($alternativeEmail) || (is_array($alternativeEmail) && empty($alternativeEmail))) {
            unset($this->AlternativeEmail);
        } else {
            $this->AlternativeEmail = $alternativeEmail;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\EmailDataType
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get EmailingAccepted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEmailingAccepted()
    {
        return isset($this->EmailingAccepted) ? $this->EmailingAccepted : null;
    }
    /**
     * Set EmailingAccepted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $emailingAccepted
     * @return \StructType\EmailDataType
     */
    public function setEmailingAccepted($emailingAccepted = null)
    {
        if (is_null($emailingAccepted) || (is_array($emailingAccepted) && empty($emailingAccepted))) {
            unset($this->EmailingAccepted);
        } else {
            $this->EmailingAccepted = $emailingAccepted;
        }
        return $this;
    }
    /**
     * Get SendReceiptByMail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendReceiptByMail()
    {
        return isset($this->SendReceiptByMail) ? $this->SendReceiptByMail : null;
    }
    /**
     * Set SendReceiptByMail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendReceiptByMail
     * @return \StructType\EmailDataType
     */
    public function setSendReceiptByMail($sendReceiptByMail = null)
    {
        if (is_null($sendReceiptByMail) || (is_array($sendReceiptByMail) && empty($sendReceiptByMail))) {
            unset($this->SendReceiptByMail);
        } else {
            $this->SendReceiptByMail = $sendReceiptByMail;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmailDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
