<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerInsertData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Data for creating a new customer record.
 * - nillable: true
 * - type: tns:CustomerInsertData
 * @subpackage Structs
 */
class CustomerInsertData extends CustomerInputData
{
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2014/09 - V1105] [Optional] - Identifier of the customer to create. If not specified, the system will use the automatic code allocation. - Related to column CBR [TIERS.T_TIERS].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerId;
    /**
     * Constructor method for CustomerInsertData
     * @uses CustomerInsertData::setCustomerId()
     * @param string $customerId
     */
    public function __construct($customerId = null)
    {
        $this
            ->setCustomerId($customerId);
    }
    /**
     * Get CustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerId()
    {
        return isset($this->CustomerId) ? $this->CustomerId : null;
    }
    /**
     * Set CustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerId
     * @return \StructType\CustomerInsertData
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerId)), __LINE__);
        }
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->CustomerId);
        } else {
            $this->CustomerId = $customerId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerInsertData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
