<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Object used to store the customer's address.
 * - nillable: true
 * - type: tns:AddressDataType
 * @subpackage Structs
 */
class AddressDataType extends AbstractStructBase
{
    /**
     * The AddressLine1
     * Meta informations extracted from the WSDL
     * - documentation: Customer address - 1st line. - Related to column CBR [TIERS.T_ADRESSE1].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta informations extracted from the WSDL
     * - documentation: Customer address - 2nd line. - Related to column CBR [TIERS.T_ADRESSE2].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine2;
    /**
     * The AddressLine3
     * Meta informations extracted from the WSDL
     * - documentation: Customer address - 3rd line. - Related to column CBR [TIERS.T_ADRESSE3].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine3;
    /**
     * The BrandName
     * Meta informations extracted from the WSDL
     * - documentation: Brand name of customer's address. - Related to column CBR [TIERS.T_ENSEIGNE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrandName;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - documentation: City of customer address. - Related to column CBR [TIERS.T_VILLE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The CountryId
     * Meta informations extracted from the WSDL
     * - documentation: Country ID of customer address. - Related to column CBR [TIERS.T_PAYS].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryId;
    /**
     * The CountryIdType
     * Meta informations extracted from the WSDL
     * - documentation: Country identifier type. - Related to column CBR [TIERS.T_PAYS].
     * - minOccurs: 0
     * @var string
     */
    public $CountryIdType;
    /**
     * The Nata
     * Meta informations extracted from the WSDL
     * - documentation: Specifies if the the customer still uses this address (NPAI in France). - Related to column CBR [TIERS.T_NPAI].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Nata;
    /**
     * The RegionId
     * Meta informations extracted from the WSDL
     * - documentation: Region ID of customer address. - Related to column CBR [TIERS.T_REGION].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegionId;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - documentation: Zip code of customer address. - Related to column CBR [TIERS.T_CODEPOSTAL].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for AddressDataType
     * @uses AddressDataType::setAddressLine1()
     * @uses AddressDataType::setAddressLine2()
     * @uses AddressDataType::setAddressLine3()
     * @uses AddressDataType::setBrandName()
     * @uses AddressDataType::setCity()
     * @uses AddressDataType::setCountryId()
     * @uses AddressDataType::setCountryIdType()
     * @uses AddressDataType::setNata()
     * @uses AddressDataType::setRegionId()
     * @uses AddressDataType::setZipCode()
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $addressLine3
     * @param string $brandName
     * @param string $city
     * @param string $countryId
     * @param string $countryIdType
     * @param bool $nata
     * @param string $regionId
     * @param string $zipCode
     */
    public function __construct($addressLine1 = null, $addressLine2 = null, $addressLine3 = null, $brandName = null, $city = null, $countryId = null, $countryIdType = null, $nata = null, $regionId = null, $zipCode = null)
    {
        $this
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setBrandName($brandName)
            ->setCity($city)
            ->setCountryId($countryId)
            ->setCountryIdType($countryIdType)
            ->setNata($nata)
            ->setRegionId($regionId)
            ->setZipCode($zipCode);
    }
    /**
     * Get AddressLine1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine1()
    {
        return isset($this->AddressLine1) ? $this->AddressLine1 : null;
    }
    /**
     * Set AddressLine1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine1
     * @return \StructType\AddressDataType
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine1)), __LINE__);
        }
        if (is_null($addressLine1) || (is_array($addressLine1) && empty($addressLine1))) {
            unset($this->AddressLine1);
        } else {
            $this->AddressLine1 = $addressLine1;
        }
        return $this;
    }
    /**
     * Get AddressLine2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine2()
    {
        return isset($this->AddressLine2) ? $this->AddressLine2 : null;
    }
    /**
     * Set AddressLine2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine2
     * @return \StructType\AddressDataType
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine2)), __LINE__);
        }
        if (is_null($addressLine2) || (is_array($addressLine2) && empty($addressLine2))) {
            unset($this->AddressLine2);
        } else {
            $this->AddressLine2 = $addressLine2;
        }
        return $this;
    }
    /**
     * Get AddressLine3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine3()
    {
        return isset($this->AddressLine3) ? $this->AddressLine3 : null;
    }
    /**
     * Set AddressLine3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine3
     * @return \StructType\AddressDataType
     */
    public function setAddressLine3($addressLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine3) && !is_string($addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine3)), __LINE__);
        }
        if (is_null($addressLine3) || (is_array($addressLine3) && empty($addressLine3))) {
            unset($this->AddressLine3);
        } else {
            $this->AddressLine3 = $addressLine3;
        }
        return $this;
    }
    /**
     * Get BrandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrandName()
    {
        return isset($this->BrandName) ? $this->BrandName : null;
    }
    /**
     * Set BrandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brandName
     * @return \StructType\AddressDataType
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandName)), __LINE__);
        }
        if (is_null($brandName) || (is_array($brandName) && empty($brandName))) {
            unset($this->BrandName);
        } else {
            $this->BrandName = $brandName;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\AddressDataType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get CountryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryId()
    {
        return isset($this->CountryId) ? $this->CountryId : null;
    }
    /**
     * Set CountryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryId
     * @return \StructType\AddressDataType
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: string
        if (!is_null($countryId) && !is_string($countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryId)), __LINE__);
        }
        if (is_null($countryId) || (is_array($countryId) && empty($countryId))) {
            unset($this->CountryId);
        } else {
            $this->CountryId = $countryId;
        }
        return $this;
    }
    /**
     * Get CountryIdType value
     * @return string|null
     */
    public function getCountryIdType()
    {
        return $this->CountryIdType;
    }
    /**
     * Set CountryIdType value
     * @uses \EnumType\CountryIdType::valueIsValid()
     * @uses \EnumType\CountryIdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $countryIdType
     * @return \StructType\AddressDataType
     */
    public function setCountryIdType($countryIdType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryIdType::valueIsValid($countryIdType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $countryIdType, implode(', ', \EnumType\CountryIdType::getValidValues())), __LINE__);
        }
        $this->CountryIdType = $countryIdType;
        return $this;
    }
    /**
     * Get Nata value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNata()
    {
        return isset($this->Nata) ? $this->Nata : null;
    }
    /**
     * Set Nata value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $nata
     * @return \StructType\AddressDataType
     */
    public function setNata($nata = null)
    {
        if (is_null($nata) || (is_array($nata) && empty($nata))) {
            unset($this->Nata);
        } else {
            $this->Nata = $nata;
        }
        return $this;
    }
    /**
     * Get RegionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegionId()
    {
        return isset($this->RegionId) ? $this->RegionId : null;
    }
    /**
     * Set RegionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regionId
     * @return \StructType\AddressDataType
     */
    public function setRegionId($regionId = null)
    {
        // validation for constraint: string
        if (!is_null($regionId) && !is_string($regionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regionId)), __LINE__);
        }
        if (is_null($regionId) || (is_array($regionId) && empty($regionId))) {
            unset($this->RegionId);
        } else {
            $this->RegionId = $regionId;
        }
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \StructType\AddressDataType
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
