<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerQueryData ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCustomerQueryData
 * @subpackage Arrays
 */
class ArrayOfCustomerQueryData extends AbstractStructArrayBase
{
    /**
     * The CustomerQueryData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerQueryData[]
     */
    public $CustomerQueryData;
    /**
     * Constructor method for ArrayOfCustomerQueryData
     * @uses ArrayOfCustomerQueryData::setCustomerQueryData()
     * @param \StructType\CustomerQueryData[] $customerQueryData
     */
    public function __construct(array $customerQueryData = array())
    {
        $this
            ->setCustomerQueryData($customerQueryData);
    }
    /**
     * Get CustomerQueryData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerQueryData[]|null
     */
    public function getCustomerQueryData()
    {
        return isset($this->CustomerQueryData) ? $this->CustomerQueryData : null;
    }
    /**
     * Set CustomerQueryData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerQueryData[] $customerQueryData
     * @return \ArrayType\ArrayOfCustomerQueryData
     */
    public function setCustomerQueryData(array $customerQueryData = array())
    {
        foreach ($customerQueryData as $arrayOfCustomerQueryDataCustomerQueryDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerQueryDataCustomerQueryDataItem instanceof \StructType\CustomerQueryData) {
                throw new \InvalidArgumentException(sprintf('The CustomerQueryData property can only contain items of \StructType\CustomerQueryData, "%s" given', is_object($arrayOfCustomerQueryDataCustomerQueryDataItem) ? get_class($arrayOfCustomerQueryDataCustomerQueryDataItem) : gettype($arrayOfCustomerQueryDataCustomerQueryDataItem)), __LINE__);
            }
        }
        if (is_null($customerQueryData) || (is_array($customerQueryData) && empty($customerQueryData))) {
            unset($this->CustomerQueryData);
        } else {
            $this->CustomerQueryData = $customerQueryData;
        }
        return $this;
    }
    /**
     * Add item to CustomerQueryData value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerQueryData $item
     * @return \ArrayType\ArrayOfCustomerQueryData
     */
    public function addToCustomerQueryData(\StructType\CustomerQueryData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerQueryData) {
            throw new \InvalidArgumentException(sprintf('The CustomerQueryData property can only contain items of \StructType\CustomerQueryData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerQueryData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CustomerQueryData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CustomerQueryData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CustomerQueryData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CustomerQueryData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CustomerQueryData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerQueryData
     */
    public function getAttributeName()
    {
        return 'CustomerQueryData';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCustomerQueryData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
