<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchCustomerIdsResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns the list of customers who meet the search criteria present in the object passed as input parameter.
 * @subpackage Structs
 */
class SearchCustomerIdsResponse extends AbstractStructBase
{
    /**
     * The SearchCustomerIdsResult
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of customer records with viewable information.
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCustomerQueryData
     */
    public $SearchCustomerIdsResult;
    /**
     * Constructor method for SearchCustomerIdsResponse
     * @uses SearchCustomerIdsResponse::setSearchCustomerIdsResult()
     * @param \ArrayType\ArrayOfCustomerQueryData $searchCustomerIdsResult
     */
    public function __construct(\ArrayType\ArrayOfCustomerQueryData $searchCustomerIdsResult = null)
    {
        $this
            ->setSearchCustomerIdsResult($searchCustomerIdsResult);
    }
    /**
     * Get SearchCustomerIdsResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCustomerQueryData|null
     */
    public function getSearchCustomerIdsResult()
    {
        return isset($this->SearchCustomerIdsResult) ? $this->SearchCustomerIdsResult : null;
    }
    /**
     * Set SearchCustomerIdsResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCustomerQueryData $searchCustomerIdsResult
     * @return \StructType\SearchCustomerIdsResponse
     */
    public function setSearchCustomerIdsResult(\ArrayType\ArrayOfCustomerQueryData $searchCustomerIdsResult = null)
    {
        if (is_null($searchCustomerIdsResult) || (is_array($searchCustomerIdsResult) && empty($searchCustomerIdsResult))) {
            unset($this->SearchCustomerIdsResult);
        } else {
            $this->SearchCustomerIdsResult = $searchCustomerIdsResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchCustomerIdsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
