<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetailContext StructType
 * Meta informations extracted from the WSDL
 * - documentation: Application context.
 * - nillable: true
 * - type: tns:RetailContext
 * @subpackage Structs
 */
class RetailContext extends AbstractStructBase
{
    /**
     * The DatabaseId
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of the database to use in this execution context.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatabaseId;
    /**
     * Constructor method for RetailContext
     * @uses RetailContext::setDatabaseId()
     * @param string $databaseId
     */
    public function __construct($databaseId = null)
    {
        $this
            ->setDatabaseId($databaseId);
    }
    /**
     * Get DatabaseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatabaseId()
    {
        return isset($this->DatabaseId) ? $this->DatabaseId : null;
    }
    /**
     * Set DatabaseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $databaseId
     * @return \StructType\RetailContext
     */
    public function setDatabaseId($databaseId = null)
    {
        // validation for constraint: string
        if (!is_null($databaseId) && !is_string($databaseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseId)), __LINE__);
        }
        if (is_null($databaseId) || (is_array($databaseId) && empty($databaseId))) {
            unset($this->DatabaseId);
        } else {
            $this->DatabaseId = $databaseId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RetailContext
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
