<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhoneDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Customer's phones.
 * - nillable: true
 * - type: tns:PhoneDataType
 * @subpackage Structs
 */
class PhoneDataType extends AbstractStructBase
{
    /**
     * The AlternativePhoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: Customer's second phone number. - Related to column CBR [TIERS.T_TELEPHONE2].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternativePhoneNumber;
    /**
     * The CellularPhoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: Customer's mobile phone. - Related to column CBR [TIERS.T_TELEX].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CellularPhoneNumber;
    /**
     * The HomePhoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: Customer's Home phone - Related to column CBR [TIERS.T_TELEPHONE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhoneNumber;
    /**
     * The OfficePhoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: Customer's Office phone. - Related to column CBR [TIERS.T_FAX].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OfficePhoneNumber;
    /**
     * Constructor method for PhoneDataType
     * @uses PhoneDataType::setAlternativePhoneNumber()
     * @uses PhoneDataType::setCellularPhoneNumber()
     * @uses PhoneDataType::setHomePhoneNumber()
     * @uses PhoneDataType::setOfficePhoneNumber()
     * @param string $alternativePhoneNumber
     * @param string $cellularPhoneNumber
     * @param string $homePhoneNumber
     * @param string $officePhoneNumber
     */
    public function __construct($alternativePhoneNumber = null, $cellularPhoneNumber = null, $homePhoneNumber = null, $officePhoneNumber = null)
    {
        $this
            ->setAlternativePhoneNumber($alternativePhoneNumber)
            ->setCellularPhoneNumber($cellularPhoneNumber)
            ->setHomePhoneNumber($homePhoneNumber)
            ->setOfficePhoneNumber($officePhoneNumber);
    }
    /**
     * Get AlternativePhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternativePhoneNumber()
    {
        return isset($this->AlternativePhoneNumber) ? $this->AlternativePhoneNumber : null;
    }
    /**
     * Set AlternativePhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternativePhoneNumber
     * @return \StructType\PhoneDataType
     */
    public function setAlternativePhoneNumber($alternativePhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($alternativePhoneNumber) && !is_string($alternativePhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternativePhoneNumber)), __LINE__);
        }
        if (is_null($alternativePhoneNumber) || (is_array($alternativePhoneNumber) && empty($alternativePhoneNumber))) {
            unset($this->AlternativePhoneNumber);
        } else {
            $this->AlternativePhoneNumber = $alternativePhoneNumber;
        }
        return $this;
    }
    /**
     * Get CellularPhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCellularPhoneNumber()
    {
        return isset($this->CellularPhoneNumber) ? $this->CellularPhoneNumber : null;
    }
    /**
     * Set CellularPhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cellularPhoneNumber
     * @return \StructType\PhoneDataType
     */
    public function setCellularPhoneNumber($cellularPhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cellularPhoneNumber) && !is_string($cellularPhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cellularPhoneNumber)), __LINE__);
        }
        if (is_null($cellularPhoneNumber) || (is_array($cellularPhoneNumber) && empty($cellularPhoneNumber))) {
            unset($this->CellularPhoneNumber);
        } else {
            $this->CellularPhoneNumber = $cellularPhoneNumber;
        }
        return $this;
    }
    /**
     * Get HomePhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhoneNumber()
    {
        return isset($this->HomePhoneNumber) ? $this->HomePhoneNumber : null;
    }
    /**
     * Set HomePhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhoneNumber
     * @return \StructType\PhoneDataType
     */
    public function setHomePhoneNumber($homePhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($homePhoneNumber) && !is_string($homePhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homePhoneNumber)), __LINE__);
        }
        if (is_null($homePhoneNumber) || (is_array($homePhoneNumber) && empty($homePhoneNumber))) {
            unset($this->HomePhoneNumber);
        } else {
            $this->HomePhoneNumber = $homePhoneNumber;
        }
        return $this;
    }
    /**
     * Get OfficePhoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOfficePhoneNumber()
    {
        return isset($this->OfficePhoneNumber) ? $this->OfficePhoneNumber : null;
    }
    /**
     * Set OfficePhoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $officePhoneNumber
     * @return \StructType\PhoneDataType
     */
    public function setOfficePhoneNumber($officePhoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($officePhoneNumber) && !is_string($officePhoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($officePhoneNumber)), __LINE__);
        }
        if (is_null($officePhoneNumber) || (is_array($officePhoneNumber) && empty($officePhoneNumber))) {
            unset($this->OfficePhoneNumber);
        } else {
            $this->OfficePhoneNumber = $officePhoneNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PhoneDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
