<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerIdByReference StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns the identifier of the customer matching a given customer reference.
 * @subpackage Structs
 */
class GetCustomerIdByReference extends AbstractStructBase
{
    /**
     * The customerReference
     * Meta informations extracted from the WSDL
     * - documentation: Reference enabling the identification of the customer.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $customerReference;
    /**
     * The clientContext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetailContext
     */
    public $clientContext;
    /**
     * Constructor method for GetCustomerIdByReference
     * @uses GetCustomerIdByReference::setCustomerReference()
     * @uses GetCustomerIdByReference::setClientContext()
     * @param string $customerReference
     * @param \StructType\RetailContext $clientContext
     */
    public function __construct($customerReference = null, \StructType\RetailContext $clientContext = null)
    {
        $this
            ->setCustomerReference($customerReference)
            ->setClientContext($clientContext);
    }
    /**
     * Get customerReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerReference()
    {
        return isset($this->customerReference) ? $this->customerReference : null;
    }
    /**
     * Set customerReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerReference
     * @return \StructType\GetCustomerIdByReference
     */
    public function setCustomerReference($customerReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference) && !is_string($customerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerReference)), __LINE__);
        }
        if (is_null($customerReference) || (is_array($customerReference) && empty($customerReference))) {
            unset($this->customerReference);
        } else {
            $this->customerReference = $customerReference;
        }
        return $this;
    }
    /**
     * Get clientContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetailContext|null
     */
    public function getClientContext()
    {
        return isset($this->clientContext) ? $this->clientContext : null;
    }
    /**
     * Set clientContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetailContext $clientContext
     * @return \StructType\GetCustomerIdByReference
     */
    public function setClientContext(\StructType\RetailContext $clientContext = null)
    {
        if (is_null($clientContext) || (is_array($clientContext) && empty($clientContext))) {
            unset($this->clientContext);
        } else {
            $this->clientContext = $clientContext;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerIdByReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
