<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerQueryData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Viewable data of a customer record.
 * - nillable: true
 * - type: tns:CustomerQueryData
 * @subpackage Structs
 */
class CustomerQueryData extends CustomerData
{
    /**
     * The Closed
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2014/02 - V1105] [Beta] - Customer closed. - Related to column CBR [TIERS.T_FERME].
     * - minOccurs: 0
     * @var bool
     */
    public $Closed;
    /**
     * The CreationStoreId
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of the store where the customer was created. - Related to column CBR [TIERS.T_ETABCREATION].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationStoreId;
    /**
     * The CustomerId
     * Meta informations extracted from the WSDL
     * - documentation: Customer's ID. - Related to column CBR [TIERS.T_TIERS].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerId;
    /**
     * The InvoiceCustomerId
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of the invoiced customer associated with the customer. - Related to column CBR [TIERS.T_TIERSFACTURE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceCustomerId;
    /**
     * The IsProspect
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2016/11 - V1201] - ??? Propriété indiquant si le client est prospect. ??? - Related to column CBR [TIERS.T_NATUREAUXI].
     * - minOccurs: 0
     * @var bool
     */
    public $IsProspect;
    /**
     * The IsVirtual
     * Meta informations extracted from the WSDL
     * - documentation: Property specifying if the customer is fictitious or unknown. - Related to column CBR [TIERS.T_TIERSFICTIF].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVirtual;
    /**
     * The LastDateUpdate
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2016/04 - V1110] [Beta] - Date of the latest change of the customer - Related to column CBR [TIERS.T_DTSVLASTCHANGE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastDateUpdate;
    /**
     * Constructor method for CustomerQueryData
     * @uses CustomerQueryData::setClosed()
     * @uses CustomerQueryData::setCreationStoreId()
     * @uses CustomerQueryData::setCustomerId()
     * @uses CustomerQueryData::setInvoiceCustomerId()
     * @uses CustomerQueryData::setIsProspect()
     * @uses CustomerQueryData::setIsVirtual()
     * @uses CustomerQueryData::setLastDateUpdate()
     * @param bool $closed
     * @param string $creationStoreId
     * @param string $customerId
     * @param string $invoiceCustomerId
     * @param bool $isProspect
     * @param bool $isVirtual
     * @param string $lastDateUpdate
     */
    public function __construct($closed = null, $creationStoreId = null, $customerId = null, $invoiceCustomerId = null, $isProspect = null, $isVirtual = null, $lastDateUpdate = null)
    {
        $this
            ->setClosed($closed)
            ->setCreationStoreId($creationStoreId)
            ->setCustomerId($customerId)
            ->setInvoiceCustomerId($invoiceCustomerId)
            ->setIsProspect($isProspect)
            ->setIsVirtual($isVirtual)
            ->setLastDateUpdate($lastDateUpdate);
    }
    /**
     * Get Closed value
     * @return bool|null
     */
    public function getClosed()
    {
        return $this->Closed;
    }
    /**
     * Set Closed value
     * @param bool $closed
     * @return \StructType\CustomerQueryData
     */
    public function setClosed($closed = null)
    {
        $this->Closed = $closed;
        return $this;
    }
    /**
     * Get CreationStoreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationStoreId()
    {
        return isset($this->CreationStoreId) ? $this->CreationStoreId : null;
    }
    /**
     * Set CreationStoreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationStoreId
     * @return \StructType\CustomerQueryData
     */
    public function setCreationStoreId($creationStoreId = null)
    {
        // validation for constraint: string
        if (!is_null($creationStoreId) && !is_string($creationStoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationStoreId)), __LINE__);
        }
        if (is_null($creationStoreId) || (is_array($creationStoreId) && empty($creationStoreId))) {
            unset($this->CreationStoreId);
        } else {
            $this->CreationStoreId = $creationStoreId;
        }
        return $this;
    }
    /**
     * Get CustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerId()
    {
        return isset($this->CustomerId) ? $this->CustomerId : null;
    }
    /**
     * Set CustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerId
     * @return \StructType\CustomerQueryData
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerId)), __LINE__);
        }
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->CustomerId);
        } else {
            $this->CustomerId = $customerId;
        }
        return $this;
    }
    /**
     * Get InvoiceCustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceCustomerId()
    {
        return isset($this->InvoiceCustomerId) ? $this->InvoiceCustomerId : null;
    }
    /**
     * Set InvoiceCustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceCustomerId
     * @return \StructType\CustomerQueryData
     */
    public function setInvoiceCustomerId($invoiceCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceCustomerId) && !is_string($invoiceCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceCustomerId)), __LINE__);
        }
        if (is_null($invoiceCustomerId) || (is_array($invoiceCustomerId) && empty($invoiceCustomerId))) {
            unset($this->InvoiceCustomerId);
        } else {
            $this->InvoiceCustomerId = $invoiceCustomerId;
        }
        return $this;
    }
    /**
     * Get IsProspect value
     * @return bool|null
     */
    public function getIsProspect()
    {
        return $this->IsProspect;
    }
    /**
     * Set IsProspect value
     * @param bool $isProspect
     * @return \StructType\CustomerQueryData
     */
    public function setIsProspect($isProspect = null)
    {
        $this->IsProspect = $isProspect;
        return $this;
    }
    /**
     * Get IsVirtual value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVirtual()
    {
        return isset($this->IsVirtual) ? $this->IsVirtual : null;
    }
    /**
     * Set IsVirtual value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVirtual
     * @return \StructType\CustomerQueryData
     */
    public function setIsVirtual($isVirtual = null)
    {
        if (is_null($isVirtual) || (is_array($isVirtual) && empty($isVirtual))) {
            unset($this->IsVirtual);
        } else {
            $this->IsVirtual = $isVirtual;
        }
        return $this;
    }
    /**
     * Get LastDateUpdate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastDateUpdate()
    {
        return isset($this->LastDateUpdate) ? $this->LastDateUpdate : null;
    }
    /**
     * Set LastDateUpdate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastDateUpdate
     * @return \StructType\CustomerQueryData
     */
    public function setLastDateUpdate($lastDateUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($lastDateUpdate) && !is_string($lastDateUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastDateUpdate)), __LINE__);
        }
        if (is_null($lastDateUpdate) || (is_array($lastDateUpdate) && empty($lastDateUpdate))) {
            unset($this->LastDateUpdate);
        } else {
            $this->LastDateUpdate = $lastDateUpdate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerQueryData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
