<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerDataBase StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerDataBase
 * @subpackage Structs
 */
class CustomerDataBase extends AbstractStructBase
{
    /**
     * The AddressData
     * Meta informations extracted from the WSDL
     * - documentation: [Optional].
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AddressDataType
     */
    public $AddressData;
    /**
     * The AlternateFirstName
     * Meta informations extracted from the WSDL
     * - documentation: Customer's middle name. - Related to column CBR [TIERS.T_PRENOM2].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternateFirstName;
    /**
     * The AlternateLastName
     * Meta informations extracted from the WSDL
     * - documentation: Customer's alternate last name. - Related to column CBR [TIERS.T_NOM2].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternateLastName;
    /**
     * The EmailData
     * Meta informations extracted from the WSDL
     * - documentation: [Optional].
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmailDataType
     */
    public $EmailData;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - documentation: Customer's first name - Related to column CBR [TIERS.T_PRENOM].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The IsCompany
     * Meta informations extracted from the WSDL
     * - documentation: Property specifying if the customer is a company. - Related to column CBR [TIERS.T_PARTICULIER].
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCompany;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - documentation: Customer's last name. - Related to column CBR [TIERS.T_LIBELLE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The PhoneData
     * Meta informations extracted from the WSDL
     * - documentation: [Optional].
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PhoneDataType
     */
    public $PhoneData;
    /**
     * The SalesPerson2Id
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2015/09 - V1201] [Optional] - Identifier of seller #2 - Related to column CBR [TIERSCOMPL.YTC_REPRESENTANT2].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesPerson2Id;
    /**
     * The SalesPerson3Id
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2015/09 - V1201] [Optional] - Identifier of seller #3 - Related to column CBR [TIERSCOMPL.YTC_REPRESENTANT3].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesPerson3Id;
    /**
     * The SalesPersonId
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2015/09 - V1201] [Optional] - Identifier of main seller - Related to column CBR [TIERS.T_REPRESENTANT].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesPersonId;
    /**
     * The TitleId
     * Meta informations extracted from the WSDL
     * - documentation: Customer's title. - Related to column CBR [TIERS.T_JURIDIQUE].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TitleId;
    /**
     * The UserDefinedBooleans
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/07] [Alpha] - Customer's user-defined Booleans. - Related to column CBR [TIERSCOMPL.YTC_BOOLLIBRE1..3].
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfUserDefinedBoolean
     */
    public $UserDefinedBooleans;
    /**
     * The UserDefinedData
     * Meta informations extracted from the WSDL
     * - documentation: [Optional] - Related to column CBR [TIERSCOMPL.YTC_TABLELIBRETIERS1..A].
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UserDefinedDataType
     */
    public $UserDefinedData;
    /**
     * The UserDefinedDates
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/07] [Optional] - Customer's user-defined dates. - Related to column CBR [TIERSCOMPL.YTC_DATELIBRE1..3].
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfUserDefinedDate
     */
    public $UserDefinedDates;
    /**
     * The UserDefinedTexts
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/07] [Optional] - Customer's user-defines tables. - Related to column CBR [TIERSCOMPL.YTC_TEXTELIBRE1..3].
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfUserDefinedText
     */
    public $UserDefinedTexts;
    /**
     * The UserDefinedValues
     * Meta informations extracted from the WSDL
     * - documentation: [Added 2013/07] [Optional] - Customer's user-defined numerical values. - Related to column CBR [TIERSCOMPL.YTC_VALLIBRE1..3].
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfUserDefinedValue
     */
    public $UserDefinedValues;
    /**
     * The UsualStoreId
     * Meta informations extracted from the WSDL
     * - documentation: Customer's usual store ID. - Related to column CBR [TIERS.T_ETABLISSEMENT].
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UsualStoreId;
    /**
     * Constructor method for CustomerDataBase
     * @uses CustomerDataBase::setAddressData()
     * @uses CustomerDataBase::setAlternateFirstName()
     * @uses CustomerDataBase::setAlternateLastName()
     * @uses CustomerDataBase::setEmailData()
     * @uses CustomerDataBase::setFirstName()
     * @uses CustomerDataBase::setIsCompany()
     * @uses CustomerDataBase::setLastName()
     * @uses CustomerDataBase::setPhoneData()
     * @uses CustomerDataBase::setSalesPerson2Id()
     * @uses CustomerDataBase::setSalesPerson3Id()
     * @uses CustomerDataBase::setSalesPersonId()
     * @uses CustomerDataBase::setTitleId()
     * @uses CustomerDataBase::setUserDefinedBooleans()
     * @uses CustomerDataBase::setUserDefinedData()
     * @uses CustomerDataBase::setUserDefinedDates()
     * @uses CustomerDataBase::setUserDefinedTexts()
     * @uses CustomerDataBase::setUserDefinedValues()
     * @uses CustomerDataBase::setUsualStoreId()
     * @param \StructType\AddressDataType $addressData
     * @param string $alternateFirstName
     * @param string $alternateLastName
     * @param \StructType\EmailDataType $emailData
     * @param string $firstName
     * @param bool $isCompany
     * @param string $lastName
     * @param \StructType\PhoneDataType $phoneData
     * @param string $salesPerson2Id
     * @param string $salesPerson3Id
     * @param string $salesPersonId
     * @param string $titleId
     * @param \ArrayType\ArrayOfUserDefinedBoolean $userDefinedBooleans
     * @param \StructType\UserDefinedDataType $userDefinedData
     * @param \ArrayType\ArrayOfUserDefinedDate $userDefinedDates
     * @param \ArrayType\ArrayOfUserDefinedText $userDefinedTexts
     * @param \ArrayType\ArrayOfUserDefinedValue $userDefinedValues
     * @param string $usualStoreId
     */
    public function __construct(\StructType\AddressDataType $addressData = null, $alternateFirstName = null, $alternateLastName = null, \StructType\EmailDataType $emailData = null, $firstName = null, $isCompany = null, $lastName = null, \StructType\PhoneDataType $phoneData = null, $salesPerson2Id = null, $salesPerson3Id = null, $salesPersonId = null, $titleId = null, \ArrayType\ArrayOfUserDefinedBoolean $userDefinedBooleans = null, \StructType\UserDefinedDataType $userDefinedData = null, \ArrayType\ArrayOfUserDefinedDate $userDefinedDates = null, \ArrayType\ArrayOfUserDefinedText $userDefinedTexts = null, \ArrayType\ArrayOfUserDefinedValue $userDefinedValues = null, $usualStoreId = null)
    {
        $this
            ->setAddressData($addressData)
            ->setAlternateFirstName($alternateFirstName)
            ->setAlternateLastName($alternateLastName)
            ->setEmailData($emailData)
            ->setFirstName($firstName)
            ->setIsCompany($isCompany)
            ->setLastName($lastName)
            ->setPhoneData($phoneData)
            ->setSalesPerson2Id($salesPerson2Id)
            ->setSalesPerson3Id($salesPerson3Id)
            ->setSalesPersonId($salesPersonId)
            ->setTitleId($titleId)
            ->setUserDefinedBooleans($userDefinedBooleans)
            ->setUserDefinedData($userDefinedData)
            ->setUserDefinedDates($userDefinedDates)
            ->setUserDefinedTexts($userDefinedTexts)
            ->setUserDefinedValues($userDefinedValues)
            ->setUsualStoreId($usualStoreId);
    }
    /**
     * Get AddressData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AddressDataType|null
     */
    public function getAddressData()
    {
        return isset($this->AddressData) ? $this->AddressData : null;
    }
    /**
     * Set AddressData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AddressDataType $addressData
     * @return \StructType\CustomerDataBase
     */
    public function setAddressData(\StructType\AddressDataType $addressData = null)
    {
        if (is_null($addressData) || (is_array($addressData) && empty($addressData))) {
            unset($this->AddressData);
        } else {
            $this->AddressData = $addressData;
        }
        return $this;
    }
    /**
     * Get AlternateFirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternateFirstName()
    {
        return isset($this->AlternateFirstName) ? $this->AlternateFirstName : null;
    }
    /**
     * Set AlternateFirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternateFirstName
     * @return \StructType\CustomerDataBase
     */
    public function setAlternateFirstName($alternateFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($alternateFirstName) && !is_string($alternateFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternateFirstName)), __LINE__);
        }
        if (is_null($alternateFirstName) || (is_array($alternateFirstName) && empty($alternateFirstName))) {
            unset($this->AlternateFirstName);
        } else {
            $this->AlternateFirstName = $alternateFirstName;
        }
        return $this;
    }
    /**
     * Get AlternateLastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternateLastName()
    {
        return isset($this->AlternateLastName) ? $this->AlternateLastName : null;
    }
    /**
     * Set AlternateLastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternateLastName
     * @return \StructType\CustomerDataBase
     */
    public function setAlternateLastName($alternateLastName = null)
    {
        // validation for constraint: string
        if (!is_null($alternateLastName) && !is_string($alternateLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternateLastName)), __LINE__);
        }
        if (is_null($alternateLastName) || (is_array($alternateLastName) && empty($alternateLastName))) {
            unset($this->AlternateLastName);
        } else {
            $this->AlternateLastName = $alternateLastName;
        }
        return $this;
    }
    /**
     * Get EmailData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmailDataType|null
     */
    public function getEmailData()
    {
        return isset($this->EmailData) ? $this->EmailData : null;
    }
    /**
     * Set EmailData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\EmailDataType $emailData
     * @return \StructType\CustomerDataBase
     */
    public function setEmailData(\StructType\EmailDataType $emailData = null)
    {
        if (is_null($emailData) || (is_array($emailData) && empty($emailData))) {
            unset($this->EmailData);
        } else {
            $this->EmailData = $emailData;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\CustomerDataBase
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get IsCompany value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCompany()
    {
        return isset($this->IsCompany) ? $this->IsCompany : null;
    }
    /**
     * Set IsCompany value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCompany
     * @return \StructType\CustomerDataBase
     */
    public function setIsCompany($isCompany = null)
    {
        if (is_null($isCompany) || (is_array($isCompany) && empty($isCompany))) {
            unset($this->IsCompany);
        } else {
            $this->IsCompany = $isCompany;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\CustomerDataBase
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get PhoneData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PhoneDataType|null
     */
    public function getPhoneData()
    {
        return isset($this->PhoneData) ? $this->PhoneData : null;
    }
    /**
     * Set PhoneData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PhoneDataType $phoneData
     * @return \StructType\CustomerDataBase
     */
    public function setPhoneData(\StructType\PhoneDataType $phoneData = null)
    {
        if (is_null($phoneData) || (is_array($phoneData) && empty($phoneData))) {
            unset($this->PhoneData);
        } else {
            $this->PhoneData = $phoneData;
        }
        return $this;
    }
    /**
     * Get SalesPerson2Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesPerson2Id()
    {
        return isset($this->SalesPerson2Id) ? $this->SalesPerson2Id : null;
    }
    /**
     * Set SalesPerson2Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesPerson2Id
     * @return \StructType\CustomerDataBase
     */
    public function setSalesPerson2Id($salesPerson2Id = null)
    {
        // validation for constraint: string
        if (!is_null($salesPerson2Id) && !is_string($salesPerson2Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesPerson2Id)), __LINE__);
        }
        if (is_null($salesPerson2Id) || (is_array($salesPerson2Id) && empty($salesPerson2Id))) {
            unset($this->SalesPerson2Id);
        } else {
            $this->SalesPerson2Id = $salesPerson2Id;
        }
        return $this;
    }
    /**
     * Get SalesPerson3Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesPerson3Id()
    {
        return isset($this->SalesPerson3Id) ? $this->SalesPerson3Id : null;
    }
    /**
     * Set SalesPerson3Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesPerson3Id
     * @return \StructType\CustomerDataBase
     */
    public function setSalesPerson3Id($salesPerson3Id = null)
    {
        // validation for constraint: string
        if (!is_null($salesPerson3Id) && !is_string($salesPerson3Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesPerson3Id)), __LINE__);
        }
        if (is_null($salesPerson3Id) || (is_array($salesPerson3Id) && empty($salesPerson3Id))) {
            unset($this->SalesPerson3Id);
        } else {
            $this->SalesPerson3Id = $salesPerson3Id;
        }
        return $this;
    }
    /**
     * Get SalesPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesPersonId()
    {
        return isset($this->SalesPersonId) ? $this->SalesPersonId : null;
    }
    /**
     * Set SalesPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesPersonId
     * @return \StructType\CustomerDataBase
     */
    public function setSalesPersonId($salesPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($salesPersonId) && !is_string($salesPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesPersonId)), __LINE__);
        }
        if (is_null($salesPersonId) || (is_array($salesPersonId) && empty($salesPersonId))) {
            unset($this->SalesPersonId);
        } else {
            $this->SalesPersonId = $salesPersonId;
        }
        return $this;
    }
    /**
     * Get TitleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitleId()
    {
        return isset($this->TitleId) ? $this->TitleId : null;
    }
    /**
     * Set TitleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titleId
     * @return \StructType\CustomerDataBase
     */
    public function setTitleId($titleId = null)
    {
        // validation for constraint: string
        if (!is_null($titleId) && !is_string($titleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($titleId)), __LINE__);
        }
        if (is_null($titleId) || (is_array($titleId) && empty($titleId))) {
            unset($this->TitleId);
        } else {
            $this->TitleId = $titleId;
        }
        return $this;
    }
    /**
     * Get UserDefinedBooleans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfUserDefinedBoolean|null
     */
    public function getUserDefinedBooleans()
    {
        return isset($this->UserDefinedBooleans) ? $this->UserDefinedBooleans : null;
    }
    /**
     * Set UserDefinedBooleans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfUserDefinedBoolean $userDefinedBooleans
     * @return \StructType\CustomerDataBase
     */
    public function setUserDefinedBooleans(\ArrayType\ArrayOfUserDefinedBoolean $userDefinedBooleans = null)
    {
        if (is_null($userDefinedBooleans) || (is_array($userDefinedBooleans) && empty($userDefinedBooleans))) {
            unset($this->UserDefinedBooleans);
        } else {
            $this->UserDefinedBooleans = $userDefinedBooleans;
        }
        return $this;
    }
    /**
     * Get UserDefinedData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UserDefinedDataType|null
     */
    public function getUserDefinedData()
    {
        return isset($this->UserDefinedData) ? $this->UserDefinedData : null;
    }
    /**
     * Set UserDefinedData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\UserDefinedDataType $userDefinedData
     * @return \StructType\CustomerDataBase
     */
    public function setUserDefinedData(\StructType\UserDefinedDataType $userDefinedData = null)
    {
        if (is_null($userDefinedData) || (is_array($userDefinedData) && empty($userDefinedData))) {
            unset($this->UserDefinedData);
        } else {
            $this->UserDefinedData = $userDefinedData;
        }
        return $this;
    }
    /**
     * Get UserDefinedDates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfUserDefinedDate|null
     */
    public function getUserDefinedDates()
    {
        return isset($this->UserDefinedDates) ? $this->UserDefinedDates : null;
    }
    /**
     * Set UserDefinedDates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfUserDefinedDate $userDefinedDates
     * @return \StructType\CustomerDataBase
     */
    public function setUserDefinedDates(\ArrayType\ArrayOfUserDefinedDate $userDefinedDates = null)
    {
        if (is_null($userDefinedDates) || (is_array($userDefinedDates) && empty($userDefinedDates))) {
            unset($this->UserDefinedDates);
        } else {
            $this->UserDefinedDates = $userDefinedDates;
        }
        return $this;
    }
    /**
     * Get UserDefinedTexts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfUserDefinedText|null
     */
    public function getUserDefinedTexts()
    {
        return isset($this->UserDefinedTexts) ? $this->UserDefinedTexts : null;
    }
    /**
     * Set UserDefinedTexts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfUserDefinedText $userDefinedTexts
     * @return \StructType\CustomerDataBase
     */
    public function setUserDefinedTexts(\ArrayType\ArrayOfUserDefinedText $userDefinedTexts = null)
    {
        if (is_null($userDefinedTexts) || (is_array($userDefinedTexts) && empty($userDefinedTexts))) {
            unset($this->UserDefinedTexts);
        } else {
            $this->UserDefinedTexts = $userDefinedTexts;
        }
        return $this;
    }
    /**
     * Get UserDefinedValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfUserDefinedValue|null
     */
    public function getUserDefinedValues()
    {
        return isset($this->UserDefinedValues) ? $this->UserDefinedValues : null;
    }
    /**
     * Set UserDefinedValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfUserDefinedValue $userDefinedValues
     * @return \StructType\CustomerDataBase
     */
    public function setUserDefinedValues(\ArrayType\ArrayOfUserDefinedValue $userDefinedValues = null)
    {
        if (is_null($userDefinedValues) || (is_array($userDefinedValues) && empty($userDefinedValues))) {
            unset($this->UserDefinedValues);
        } else {
            $this->UserDefinedValues = $userDefinedValues;
        }
        return $this;
    }
    /**
     * Get UsualStoreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsualStoreId()
    {
        return isset($this->UsualStoreId) ? $this->UsualStoreId : null;
    }
    /**
     * Set UsualStoreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $usualStoreId
     * @return \StructType\CustomerDataBase
     */
    public function setUsualStoreId($usualStoreId = null)
    {
        // validation for constraint: string
        if (!is_null($usualStoreId) && !is_string($usualStoreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usualStoreId)), __LINE__);
        }
        if (is_null($usualStoreId) || (is_array($usualStoreId) && empty($usualStoreId))) {
            unset($this->UsualStoreId);
        } else {
            $this->UsualStoreId = $usualStoreId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerDataBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
