<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BirthDateDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Elements of the customer's birth date.
 * - nillable: true
 * - type: tns:BirthDateDataType
 * @subpackage Structs
 */
class BirthDateDataType extends AbstractStructBase
{
    /**
     * The BirthDateDay
     * Meta informations extracted from the WSDL
     * - documentation: Day of birth. - Related to column CBR [TIERS.T_JOURNAISSANCE].
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BirthDateDay;
    /**
     * The BirthDateMonth
     * Meta informations extracted from the WSDL
     * - documentation: Month of birth. - Related to column CBR [TIERS.T_MOISNAISSANCE].
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BirthDateMonth;
    /**
     * The BirthDateYear
     * Meta informations extracted from the WSDL
     * - documentation: Year of birth. - Related to column CBR [TIERS.T_ANNEENAISSANCE].
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BirthDateYear;
    /**
     * Constructor method for BirthDateDataType
     * @uses BirthDateDataType::setBirthDateDay()
     * @uses BirthDateDataType::setBirthDateMonth()
     * @uses BirthDateDataType::setBirthDateYear()
     * @param int $birthDateDay
     * @param int $birthDateMonth
     * @param int $birthDateYear
     */
    public function __construct($birthDateDay = null, $birthDateMonth = null, $birthDateYear = null)
    {
        $this
            ->setBirthDateDay($birthDateDay)
            ->setBirthDateMonth($birthDateMonth)
            ->setBirthDateYear($birthDateYear);
    }
    /**
     * Get BirthDateDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBirthDateDay()
    {
        return isset($this->BirthDateDay) ? $this->BirthDateDay : null;
    }
    /**
     * Set BirthDateDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $birthDateDay
     * @return \StructType\BirthDateDataType
     */
    public function setBirthDateDay($birthDateDay = null)
    {
        // validation for constraint: int
        if (!is_null($birthDateDay) && !is_numeric($birthDateDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($birthDateDay)), __LINE__);
        }
        if (is_null($birthDateDay) || (is_array($birthDateDay) && empty($birthDateDay))) {
            unset($this->BirthDateDay);
        } else {
            $this->BirthDateDay = $birthDateDay;
        }
        return $this;
    }
    /**
     * Get BirthDateMonth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBirthDateMonth()
    {
        return isset($this->BirthDateMonth) ? $this->BirthDateMonth : null;
    }
    /**
     * Set BirthDateMonth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $birthDateMonth
     * @return \StructType\BirthDateDataType
     */
    public function setBirthDateMonth($birthDateMonth = null)
    {
        // validation for constraint: int
        if (!is_null($birthDateMonth) && !is_numeric($birthDateMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($birthDateMonth)), __LINE__);
        }
        if (is_null($birthDateMonth) || (is_array($birthDateMonth) && empty($birthDateMonth))) {
            unset($this->BirthDateMonth);
        } else {
            $this->BirthDateMonth = $birthDateMonth;
        }
        return $this;
    }
    /**
     * Get BirthDateYear value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBirthDateYear()
    {
        return isset($this->BirthDateYear) ? $this->BirthDateYear : null;
    }
    /**
     * Set BirthDateYear value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $birthDateYear
     * @return \StructType\BirthDateDataType
     */
    public function setBirthDateYear($birthDateYear = null)
    {
        // validation for constraint: int
        if (!is_null($birthDateYear) && !is_numeric($birthDateYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($birthDateYear)), __LINE__);
        }
        if (is_null($birthDateYear) || (is_array($birthDateYear) && empty($birthDateYear))) {
            unset($this->BirthDateYear);
        } else {
            $this->BirthDateYear = $birthDateYear;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BirthDateDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
