<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SearchCustomerIds
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of customers who meet the search criteria present in the object passed as input parameter. | Returns the list of customer records with viewable information.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SearchCustomerIds $parameters
     * @return \StructType\SearchCustomerIdsResponse|bool
     */
    public function SearchCustomerIds(\StructType\SearchCustomerIds $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SearchCustomerIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SearchCustomerIdsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
