<?php

namespace EnumType;

/**
 * This class stands for UserFieldKind EnumType
 * Meta informations extracted from the WSDL
 * - documentation: User-defined field type
 * - nillable: true
 * - type: tns:UserFieldKind
 * @subpackage Enumerations
 */
class UserFieldKind
{
    /**
     * Constant for value 'BooleanValueKind'
     * @return string 'BooleanValueKind'
     */
    const VALUE_BOOLEAN_VALUE_KIND = 'BooleanValueKind';
    /**
     * Constant for value 'TextValueKind'
     * @return string 'TextValueKind'
     */
    const VALUE_TEXT_VALUE_KIND = 'TextValueKind';
    /**
     * Constant for value 'DateValueKind'
     * @return string 'DateValueKind'
     */
    const VALUE_DATE_VALUE_KIND = 'DateValueKind';
    /**
     * Constant for value 'ListElementValueKind'
     * @return string 'ListElementValueKind'
     */
    const VALUE_LIST_ELEMENT_VALUE_KIND = 'ListElementValueKind';
    /**
     * Constant for value 'NumberValueKind'
     * @return string 'NumberValueKind'
     */
    const VALUE_NUMBER_VALUE_KIND = 'NumberValueKind';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BOOLEAN_VALUE_KIND
     * @uses self::VALUE_TEXT_VALUE_KIND
     * @uses self::VALUE_DATE_VALUE_KIND
     * @uses self::VALUE_LIST_ELEMENT_VALUE_KIND
     * @uses self::VALUE_NUMBER_VALUE_KIND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BOOLEAN_VALUE_KIND,
            self::VALUE_TEXT_VALUE_KIND,
            self::VALUE_DATE_VALUE_KIND,
            self::VALUE_LIST_ELEMENT_VALUE_KIND,
            self::VALUE_NUMBER_VALUE_KIND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
