<?php

namespace EnumType;

/**
 * This class stands for CountryIdType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Country code type ID.
 * - nillable: true
 * - type: tns:CountryIdType
 * @subpackage Enumerations
 */
class CountryIdType
{
    /**
     * Constant for value 'Internal'
     * @return string 'Internal'
     */
    const VALUE_INTERNAL = 'Internal';
    /**
     * Constant for value 'ISO2'
     * @return string 'ISO2'
     */
    const VALUE_ISO_2 = 'ISO2';
    /**
     * Constant for value 'ISO3'
     * @return string 'ISO3'
     */
    const VALUE_ISO_3 = 'ISO3';
    /**
     * Constant for value 'ISO3Numeric'
     * @return string 'ISO3Numeric'
     */
    const VALUE_ISO_3_NUMERIC = 'ISO3Numeric';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INTERNAL
     * @uses self::VALUE_ISO_2
     * @uses self::VALUE_ISO_3
     * @uses self::VALUE_ISO_3_NUMERIC
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INTERNAL,
            self::VALUE_ISO_2,
            self::VALUE_ISO_3,
            self::VALUE_ISO_3_NUMERIC,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
