<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCommune ArrayType
 * @subpackage Arrays
 */
class ArrayOfCommune extends AbstractStructArrayBase
{
    /**
     * The Commune
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Commune[]
     */
    public $Commune;
    /**
     * Constructor method for ArrayOfCommune
     * @uses ArrayOfCommune::setCommune()
     * @param \StructType\Commune[] $commune
     */
    public function __construct(array $commune = array())
    {
        $this
            ->setCommune($commune);
    }
    /**
     * Get Commune value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Commune[]|null
     */
    public function getCommune()
    {
        return isset($this->Commune) ? $this->Commune : null;
    }
    /**
     * Set Commune value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Commune[] $commune
     * @return \ArrayType\ArrayOfCommune
     */
    public function setCommune(array $commune = array())
    {
        foreach ($commune as $arrayOfCommuneCommuneItem) {
            // validation for constraint: itemType
            if (!$arrayOfCommuneCommuneItem instanceof \StructType\Commune) {
                throw new \InvalidArgumentException(sprintf('The Commune property can only contain items of \StructType\Commune, "%s" given', is_object($arrayOfCommuneCommuneItem) ? get_class($arrayOfCommuneCommuneItem) : gettype($arrayOfCommuneCommuneItem)), __LINE__);
            }
        }
        if (is_null($commune) || (is_array($commune) && empty($commune))) {
            unset($this->Commune);
        } else {
            $this->Commune = $commune;
        }
        return $this;
    }
    /**
     * Add item to Commune value
     * @throws \InvalidArgumentException
     * @param \StructType\Commune $item
     * @return \ArrayType\ArrayOfCommune
     */
    public function addToCommune(\StructType\Commune $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Commune) {
            throw new \InvalidArgumentException(sprintf('The Commune property can only contain items of \StructType\Commune, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Commune[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Commune|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Commune|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Commune|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Commune|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Commune|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Commune
     */
    public function getAttributeName()
    {
        return 'Commune';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCommune
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
