<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for WSIT ServiceType
 * @subpackage Services
 */
class WSIT extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named WSI2_TracingColisDetaille
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WSI2_TracingColisDetaille $parameters
     * @return \StructType\WSI2_TracingColisDetailleResponse|bool
     */
    public function WSI2_TracingColisDetaille(\StructType\WSI2_TracingColisDetaille $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WSI2_TracingColisDetaille($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WSI2_TracingColisDetailleResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
