<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for WSISTATL ServiceType
 * @subpackage Services
 */
class WSISTATL extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named WSI2_STAT_Label
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WSI2_STAT_Label $parameters
     * @return \StructType\WSI2_STAT_LabelResponse|bool
     */
    public function WSI2_STAT_Label(\StructType\WSI2_STAT_Label $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WSI2_STAT_Label($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named WSI2_STAT_Labels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\WSI2_STAT_Labels $parameters
     * @return \StructType\WSI2_STAT_LabelsResponse|bool
     */
    public function WSI2_STAT_Labels(\StructType\WSI2_STAT_Labels $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->WSI2_STAT_Labels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\WSI2_STAT_LabelResponse|\StructType\WSI2_STAT_LabelsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
