<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPeriode ArrayType
 * @subpackage Arrays
 */
class ArrayOfPeriode extends AbstractStructArrayBase
{
    /**
     * The Periode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Periode[]
     */
    public $Periode;
    /**
     * Constructor method for ArrayOfPeriode
     * @uses ArrayOfPeriode::setPeriode()
     * @param \StructType\Periode[] $periode
     */
    public function __construct(array $periode = array())
    {
        $this
            ->setPeriode($periode);
    }
    /**
     * Get Periode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Periode[]|null
     */
    public function getPeriode()
    {
        return isset($this->Periode) ? $this->Periode : null;
    }
    /**
     * Set Periode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Periode[] $periode
     * @return \ArrayType\ArrayOfPeriode
     */
    public function setPeriode(array $periode = array())
    {
        foreach ($periode as $arrayOfPeriodePeriodeItem) {
            // validation for constraint: itemType
            if (!$arrayOfPeriodePeriodeItem instanceof \StructType\Periode) {
                throw new \InvalidArgumentException(sprintf('The Periode property can only contain items of \StructType\Periode, "%s" given', is_object($arrayOfPeriodePeriodeItem) ? get_class($arrayOfPeriodePeriodeItem) : gettype($arrayOfPeriodePeriodeItem)), __LINE__);
            }
        }
        if (is_null($periode) || (is_array($periode) && empty($periode))) {
            unset($this->Periode);
        } else {
            $this->Periode = $periode;
        }
        return $this;
    }
    /**
     * Add item to Periode value
     * @throws \InvalidArgumentException
     * @param \StructType\Periode $item
     * @return \ArrayType\ArrayOfPeriode
     */
    public function addToPeriode(\StructType\Periode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Periode) {
            throw new \InvalidArgumentException(sprintf('The Periode property can only contain items of \StructType\Periode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Periode[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Periode|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Periode|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Periode|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Periode|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Periode|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Periode
     */
    public function getAttributeName()
    {
        return 'Periode';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPeriode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
