<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Satellite StructType
 * @subpackage Structs
 */
class Satellite extends AbstractStructBase
{
    /**
     * The id
     * @var int
     */
    public $id;
    /**
     * The satName
     * @var string
     */
    public $satName;
    /**
     * The intDesignator
     * @var string
     */
    public $intDesignator;
    /**
     * The launchDate
     * @var string
     */
    public $launchDate;
    /**
     * The satLatitude
     * @var float
     */
    public $satLatitude;
    /**
     * The satLongitude
     * @var float
     */
    public $satLongitude;
    /**
     * The satAltitude
     * @var float
     */
    public $satAltitude;
    /**
     * Constructor method for Satellite
     * @uses Satellite::setId()
     * @uses Satellite::setSatName()
     * @uses Satellite::setIntDesignator()
     * @uses Satellite::setLaunchDate()
     * @uses Satellite::setSatLatitude()
     * @uses Satellite::setSatLongitude()
     * @uses Satellite::setSatAltitude()
     * @param int $id
     * @param string $satName
     * @param string $intDesignator
     * @param string $launchDate
     * @param float $satLatitude
     * @param float $satLongitude
     * @param float $satAltitude
     */
    public function __construct($id = null, $satName = null, $intDesignator = null, $launchDate = null, $satLatitude = null, $satLongitude = null, $satAltitude = null)
    {
        $this
            ->setId($id)
            ->setSatName($satName)
            ->setIntDesignator($intDesignator)
            ->setLaunchDate($launchDate)
            ->setSatLatitude($satLatitude)
            ->setSatLongitude($satLongitude)
            ->setSatAltitude($satAltitude);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\Satellite
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get satName value
     * @return string|null
     */
    public function getSatName()
    {
        return $this->satName;
    }
    /**
     * Set satName value
     * @param string $satName
     * @return \StructType\Satellite
     */
    public function setSatName($satName = null)
    {
        // validation for constraint: string
        if (!is_null($satName) && !is_string($satName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($satName)), __LINE__);
        }
        $this->satName = $satName;
        return $this;
    }
    /**
     * Get intDesignator value
     * @return string|null
     */
    public function getIntDesignator()
    {
        return $this->intDesignator;
    }
    /**
     * Set intDesignator value
     * @param string $intDesignator
     * @return \StructType\Satellite
     */
    public function setIntDesignator($intDesignator = null)
    {
        // validation for constraint: string
        if (!is_null($intDesignator) && !is_string($intDesignator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intDesignator)), __LINE__);
        }
        $this->intDesignator = $intDesignator;
        return $this;
    }
    /**
     * Get launchDate value
     * @return string|null
     */
    public function getLaunchDate()
    {
        return $this->launchDate;
    }
    /**
     * Set launchDate value
     * @param string $launchDate
     * @return \StructType\Satellite
     */
    public function setLaunchDate($launchDate = null)
    {
        // validation for constraint: string
        if (!is_null($launchDate) && !is_string($launchDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($launchDate)), __LINE__);
        }
        $this->launchDate = $launchDate;
        return $this;
    }
    /**
     * Get satLatitude value
     * @return float|null
     */
    public function getSatLatitude()
    {
        return $this->satLatitude;
    }
    /**
     * Set satLatitude value
     * @param float $satLatitude
     * @return \StructType\Satellite
     */
    public function setSatLatitude($satLatitude = null)
    {
        $this->satLatitude = $satLatitude;
        return $this;
    }
    /**
     * Get satLongitude value
     * @return float|null
     */
    public function getSatLongitude()
    {
        return $this->satLongitude;
    }
    /**
     * Set satLongitude value
     * @param float $satLongitude
     * @return \StructType\Satellite
     */
    public function setSatLongitude($satLongitude = null)
    {
        $this->satLongitude = $satLongitude;
        return $this;
    }
    /**
     * Get satAltitude value
     * @return float|null
     */
    public function getSatAltitude()
    {
        return $this->satAltitude;
    }
    /**
     * Set satAltitude value
     * @param float $satAltitude
     * @return \StructType\Satellite
     */
    public function setSatAltitude($satAltitude = null)
    {
        $this->satAltitude = $satAltitude;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Satellite
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
