<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.n2yo.com/sat/satws.php?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.n2yo.com/sat/satws.php?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetSatellitesAroundLocation operation/method
 */
if ($get->GetSatellitesAroundLocation($obsLatitude, $obsLongitude, $elevation, $category, $license) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVisiblePasses operation/method
 */
if ($get->GetVisiblePasses($id, $lat, $lng, $alt, $days, $minduration, $license) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllPasses operation/method
 */
if ($get->GetAllPasses($id, $lat, $lng, $alt, $days, $minduration, $minelevation, $license) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPositionsByAddress operation/method
 */
if ($get->GetPositionsByAddress($id, $address, $seconds, $license) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPositionsByIp operation/method
 */
if ($get->GetPositionsByIp($id, $ip, $seconds, $license) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPositionsByLatLng operation/method
 */
if ($get->GetPositionsByLatLng($id, $lat, $lng, $seconds, $license) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTLEs operation/method
 */
if ($get->GetTLEs($category, $license) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLocationByZip operation/method
 */
if ($get->GetLocationByZip($zip, $license) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSatelliteName operation/method
 */
if ($get->GetSatelliteName($id, $license) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGeoIp operation/method
 */
if ($get->GetGeoIp($ip, $license) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
