<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SatelliteInfo StructType
 * @subpackage Structs
 */
class SatelliteInfo extends AbstractStructBase
{
    /**
     * The sat_id
     * @var int
     */
    public $sat_id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The tle
     * @var string
     */
    public $tle;
    /**
     * Constructor method for SatelliteInfo
     * @uses SatelliteInfo::setSat_id()
     * @uses SatelliteInfo::setName()
     * @uses SatelliteInfo::setTle()
     * @param int $sat_id
     * @param string $name
     * @param string $tle
     */
    public function __construct($sat_id = null, $name = null, $tle = null)
    {
        $this
            ->setSat_id($sat_id)
            ->setName($name)
            ->setTle($tle);
    }
    /**
     * Get sat_id value
     * @return int|null
     */
    public function getSat_id()
    {
        return $this->sat_id;
    }
    /**
     * Set sat_id value
     * @param int $sat_id
     * @return \StructType\SatelliteInfo
     */
    public function setSat_id($sat_id = null)
    {
        // validation for constraint: int
        if (!is_null($sat_id) && !is_numeric($sat_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sat_id)), __LINE__);
        }
        $this->sat_id = $sat_id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SatelliteInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get tle value
     * @return string|null
     */
    public function getTle()
    {
        return $this->tle;
    }
    /**
     * Set tle value
     * @param string $tle
     * @return \StructType\SatelliteInfo
     */
    public function setTle($tle = null)
    {
        // validation for constraint: string
        if (!is_null($tle) && !is_string($tle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tle)), __LINE__);
        }
        $this->tle = $tle;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SatelliteInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
